/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.TrecContentSource;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DemoHTMLParser
implements HTMLParser {
    @Override
    public DocData parse(DocData docData, String name, Date date, Reader reader, TrecContentSource trecSrc) throws IOException {
        try {
            return this.parse(docData, name, date, new InputSource(reader), trecSrc);
        }
        catch (SAXException saxe) {
            throw new IOException("SAX exception occurred while parsing HTML document.", saxe);
        }
    }

    public DocData parse(DocData docData, String name, Date date, InputSource source, TrecContentSource trecSrc) throws IOException, SAXException {
        Date newDate;
        Parser p = new Parser(source);
        Properties props = p.metaTags;
        String dateStr = props.getProperty("date");
        if (dateStr != null && (newDate = trecSrc.parseDate(dateStr)) != null) {
            date = newDate;
        }
        docData.clear();
        docData.setName(name);
        docData.setBody(p.body);
        docData.setTitle(p.title);
        docData.setProps(props);
        docData.setDate(date);
        return docData;
    }

    public static final class Parser {
        public final Properties metaTags = new Properties();
        public final String title;
        public final String body;
        static final Set<String> ENDLINE_ELEMENTS = Parser.createElementNameSet("p", "h1", "h2", "h3", "h4", "h5", "h6", "div", "ul", "ol", "dl", "pre", "hr", "blockquote", "address", "fieldset", "table", "form", "noscript", "li", "dt", "dd", "noframes", "br", "tr", "select", "option");
        static final Set<String> SUPPRESS_ELEMENTS = Parser.createElementNameSet("style", "script");

        public Parser(Reader reader) throws IOException, SAXException {
            this(new InputSource(reader));
        }

        public Parser(InputSource source) throws IOException, SAXException {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags", true);
            parser.setFeature("http://cyberneko.org/html/features/report-errors", false);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"lower");
            final StringBuilder title = new StringBuilder();
            final StringBuilder body = new StringBuilder();
            DefaultHandler handler = new DefaultHandler(){
                private int inBODY = 0;
                private int inHEAD = 0;
                private int inTITLE = 0;
                private int suppressed = 0;

                @Override
                public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                    if (this.inHEAD > 0) {
                        if (Parser.equalsIgnoreTurkish("title", localName)) {
                            ++this.inTITLE;
                        } else if (Parser.equalsIgnoreTurkish("meta", localName)) {
                            String name = atts.getValue("name");
                            if (name == null) {
                                name = atts.getValue("http-equiv");
                            }
                            String val = atts.getValue("content");
                            if (name != null && val != null) {
                                Parser.this.metaTags.setProperty(name.toLowerCase(Locale.ROOT), val);
                            }
                        }
                    } else if (this.inBODY > 0) {
                        String alt;
                        if (SUPPRESS_ELEMENTS.contains(localName)) {
                            ++this.suppressed;
                        } else if (Parser.equalsIgnoreTurkish("img", localName) && (alt = atts.getValue("alt")) != null) {
                            body.append('[').append(alt).append(']');
                        }
                    } else if (Parser.equalsIgnoreTurkish("body", localName)) {
                        ++this.inBODY;
                    } else if (Parser.equalsIgnoreTurkish("head", localName)) {
                        ++this.inHEAD;
                    } else if (Parser.equalsIgnoreTurkish("frameset", localName)) {
                        throw new SAXException("This parser does not support HTML framesets.");
                    }
                }

                @Override
                public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                    if (this.inBODY > 0) {
                        if (Parser.equalsIgnoreTurkish("body", localName)) {
                            --this.inBODY;
                        } else if (ENDLINE_ELEMENTS.contains(localName)) {
                            body.append('\n');
                        } else if (SUPPRESS_ELEMENTS.contains(localName)) {
                            --this.suppressed;
                        }
                    } else if (this.inHEAD > 0) {
                        if (Parser.equalsIgnoreTurkish("head", localName)) {
                            --this.inHEAD;
                        } else if (this.inTITLE > 0 && Parser.equalsIgnoreTurkish("title", localName)) {
                            --this.inTITLE;
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.inBODY > 0 && this.suppressed == 0) {
                        body.append(ch, start, length);
                    } else if (this.inTITLE > 0) {
                        title.append(ch, start, length);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new StringReader(""));
                }
            };
            parser.setContentHandler((ContentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(source);
            this.title = title.toString().trim();
            this.body = body.toString();
        }

        static final String convertTurkish(String s) {
            return s.replace('i', '\u0131');
        }

        static final boolean equalsIgnoreTurkish(String s1, String s2) {
            int len2;
            int len1 = s1.length();
            if (len1 != (len2 = s2.length())) {
                return false;
            }
            for (int i = 0; i < len1; ++i) {
                int ch1 = s1.charAt(i);
                int ch2 = s2.charAt(i);
                if (ch1 == 305) {
                    ch1 = 105;
                }
                if (ch2 == 305) {
                    ch2 = 105;
                }
                if (ch1 == ch2) continue;
                return false;
            }
            return true;
        }

        static final Set<String> createElementNameSet(String ... names) {
            HashSet<String> set = new HashSet<String>();
            for (String name : names) {
                set.add(name);
                set.add(Parser.convertTurkish(name));
            }
            return Collections.unmodifiableSet(set);
        }
    }
}

