/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;

public class DocMaker
implements Closeable {
    private Random r;
    private int updateDocIDLimit;
    private boolean storeBytes = false;
    private ThreadLocal<LeftOver> leftovr = new ThreadLocal();
    private ThreadLocal<DocState> docState = new ThreadLocal();
    private ThreadLocal<DateUtil> dateParsers = new ThreadLocal();
    public static final String BODY_FIELD = "body";
    public static final String TITLE_FIELD = "doctitle";
    public static final String DATE_FIELD = "docdate";
    public static final String DATE_MSEC_FIELD = "docdatenum";
    public static final String TIME_SEC_FIELD = "doctimesecnum";
    public static final String ID_FIELD = "docid";
    public static final String BYTES_FIELD = "bytes";
    public static final String NAME_FIELD = "docname";
    protected Config config;
    protected Field.Store storeVal = Field.Store.NO;
    protected Field.Store bodyStoreVal = Field.Store.NO;
    protected Field.Index indexVal = Field.Index.ANALYZED_NO_NORMS;
    protected Field.Index bodyIndexVal = Field.Index.ANALYZED;
    protected Field.TermVector termVecVal = Field.TermVector.NO;
    protected ContentSource source;
    protected boolean reuseFields;
    protected boolean indexProperties;
    private final AtomicInteger numDocsCreated = new AtomicInteger();

    private Document createDocument(DocData docData, int size, int cnt) throws UnsupportedEncodingException {
        Properties props;
        int id;
        DocState ds = this.getDocState();
        Document doc = this.reuseFields ? ds.doc : new Document();
        doc.getFields().clear();
        Field idField = ds.getField(ID_FIELD, this.storeVal, Field.Index.NOT_ANALYZED_NO_NORMS, this.termVecVal);
        if (this.r != null) {
            id = this.r.nextInt(this.updateDocIDLimit);
        } else {
            id = docData.getID();
            if (id == -1) {
                id = this.numDocsCreated.getAndIncrement();
            }
        }
        idField.setValue(Integer.toString(id));
        doc.add((Fieldable)idField);
        String name = docData.getName();
        if (name == null) {
            name = "";
        }
        name = cnt < 0 ? name : name + "_" + cnt;
        Field nameField = ds.getField(NAME_FIELD, this.storeVal, this.indexVal, this.termVecVal);
        nameField.setValue(name);
        doc.add((Fieldable)nameField);
        DateUtil util = this.dateParsers.get();
        if (util == null) {
            util = new DateUtil();
            this.dateParsers.set(util);
        }
        Date date = null;
        String dateString = docData.getDate();
        if (dateString != null) {
            util.pos.setIndex(0);
            date = util.parser.parse(dateString, util.pos);
        } else {
            dateString = "";
        }
        Field dateStringField = ds.getField(DATE_FIELD, this.storeVal, this.indexVal, this.termVecVal);
        dateStringField.setValue(dateString);
        doc.add((Fieldable)dateStringField);
        if (date == null) {
            date = new Date();
        }
        NumericField dateField = ds.getNumericField(DATE_MSEC_FIELD);
        dateField.setLongValue(date.getTime());
        doc.add((Fieldable)dateField);
        util.cal.setTime(date);
        int sec = util.cal.get(11) * 3600 + util.cal.get(12) * 60 + util.cal.get(13);
        NumericField timeSecField = ds.getNumericField(TIME_SEC_FIELD);
        timeSecField.setIntValue(sec);
        doc.add((Fieldable)timeSecField);
        String title = docData.getTitle();
        Field titleField = ds.getField(TITLE_FIELD, this.storeVal, this.indexVal, this.termVecVal);
        titleField.setValue(title == null ? "" : title);
        doc.add((Fieldable)titleField);
        String body = docData.getBody();
        if (body != null && body.length() > 0) {
            String bdy;
            if (size <= 0 || size >= body.length()) {
                bdy = body;
                docData.setBody("");
            } else {
                for (int n = size - 1; n < size + 20 && n < body.length(); ++n) {
                    if (!Character.isWhitespace(body.charAt(n))) continue;
                    size = n;
                    break;
                }
                bdy = body.substring(0, size);
                docData.setBody(body.substring(size));
            }
            Field bodyField = ds.getField(BODY_FIELD, this.bodyStoreVal, this.bodyIndexVal, this.termVecVal);
            bodyField.setValue(bdy);
            doc.add((Fieldable)bodyField);
            if (this.storeBytes) {
                Field bytesField = ds.getField(BYTES_FIELD, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
                bytesField.setValue(bdy.getBytes("UTF-8"));
                doc.add((Fieldable)bytesField);
            }
        }
        if (this.indexProperties && (props = docData.getProps()) != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Field f = ds.getField((String)entry.getKey(), this.storeVal, this.indexVal, this.termVecVal);
                f.setValue((String)entry.getValue());
                doc.add((Fieldable)f);
            }
            docData.setProps(null);
        }
        return doc;
    }

    private void resetLeftovers() {
        this.leftovr.set(null);
    }

    protected DocState getDocState() {
        DocState ds = this.docState.get();
        if (ds == null) {
            ds = new DocState(this.reuseFields, this.storeVal, this.bodyStoreVal, this.indexVal, this.bodyIndexVal, this.termVecVal);
            this.docState.set(ds);
        }
        return ds;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public synchronized long getBytesCount() {
        return this.source.getBytesCount();
    }

    public long getTotalBytesCount() {
        return this.source.getTotalBytesCount();
    }

    public Document makeDocument() throws Exception {
        this.resetLeftovers();
        DocData docData = this.source.getNextDocData(this.getDocState().docData);
        Document doc = this.createDocument(docData, 0, -1);
        return doc;
    }

    public Document makeDocument(int size) throws Exception {
        int cnt;
        LeftOver lvr = this.leftovr.get();
        if (lvr == null || lvr.docdata == null || lvr.docdata.getBody() == null || lvr.docdata.getBody().length() == 0) {
            this.resetLeftovers();
        }
        DocData docData = this.getDocState().docData;
        DocData dd = lvr == null ? this.source.getNextDocData(docData) : lvr.docdata;
        int n = cnt = lvr == null ? 0 : lvr.cnt;
        while (dd.getBody() == null || dd.getBody().length() < size) {
            DocData dd2 = dd;
            dd = this.source.getNextDocData(new DocData());
            cnt = 0;
            dd.setBody(dd2.getBody() + dd.getBody());
        }
        Document doc = this.createDocument(dd, size, cnt);
        if (dd.getBody() == null || dd.getBody().length() == 0) {
            this.resetLeftovers();
        } else {
            if (lvr == null) {
                lvr = new LeftOver();
                this.leftovr.set(lvr);
            }
            lvr.docdata = dd;
            lvr.cnt = ++cnt;
        }
        return doc;
    }

    public synchronized void resetInputs() throws IOException {
        this.source.printStatistics("docs");
        this.setConfig(this.config);
        this.source.resetInputs();
        this.numDocsCreated.set(0);
        this.resetLeftovers();
    }

    public void setConfig(Config config) {
        this.config = config;
        try {
            if (this.source != null) {
                this.source.close();
            }
            String sourceClass = config.get("content.source", "org.apache.lucene.benchmark.byTask.feeds.SingleDocSource");
            this.source = Class.forName(sourceClass).asSubclass(ContentSource.class).newInstance();
            this.source.setConfig(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean stored = config.get("doc.stored", false);
        boolean bodyStored = config.get("doc.body.stored", stored);
        boolean tokenized = config.get("doc.tokenized", true);
        boolean bodyTokenized = config.get("doc.body.tokenized", tokenized);
        boolean norms = config.get("doc.tokenized.norms", false);
        boolean bodyNorms = config.get("doc.body.tokenized.norms", true);
        boolean termVec = config.get("doc.term.vector", false);
        this.storeVal = stored ? Field.Store.YES : Field.Store.NO;
        Field.Store store = this.bodyStoreVal = bodyStored ? Field.Store.YES : Field.Store.NO;
        if (tokenized) {
            this.indexVal = norms ? Field.Index.ANALYZED : Field.Index.ANALYZED_NO_NORMS;
        } else {
            Field.Index index = this.indexVal = norms ? Field.Index.NOT_ANALYZED : Field.Index.NOT_ANALYZED_NO_NORMS;
        }
        this.bodyIndexVal = bodyTokenized ? (bodyNorms ? Field.Index.ANALYZED : Field.Index.ANALYZED_NO_NORMS) : (bodyNorms ? Field.Index.NOT_ANALYZED : Field.Index.NOT_ANALYZED_NO_NORMS);
        boolean termVecPositions = config.get("doc.term.vector.positions", false);
        boolean termVecOffsets = config.get("doc.term.vector.offsets", false);
        this.termVecVal = termVecPositions && termVecOffsets ? Field.TermVector.WITH_POSITIONS_OFFSETS : (termVecPositions ? Field.TermVector.WITH_POSITIONS : (termVecOffsets ? Field.TermVector.WITH_OFFSETS : (termVec ? Field.TermVector.YES : Field.TermVector.NO)));
        this.storeBytes = config.get("doc.store.body.bytes", false);
        this.reuseFields = config.get("doc.reuse.fields", true);
        this.docState = new ThreadLocal();
        this.indexProperties = config.get("doc.index.props", false);
        this.updateDocIDLimit = config.get("doc.random.id.limit", -1);
        if (this.updateDocIDLimit != -1) {
            this.r = new Random(179L);
        }
    }

    private static class DateUtil {
        public SimpleDateFormat parser = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);
        public Calendar cal = Calendar.getInstance();
        public ParsePosition pos = new ParsePosition(0);

        public DateUtil() {
            this.parser.setLenient(true);
        }
    }

    static class DocState {
        private final Map<String, Field> fields;
        private final Map<String, NumericField> numericFields;
        private final boolean reuseFields;
        final Document doc;
        DocData docData = new DocData();

        public DocState(boolean reuseFields, Field.Store store, Field.Store bodyStore, Field.Index index, Field.Index bodyIndex, Field.TermVector termVector) {
            this.reuseFields = reuseFields;
            if (reuseFields) {
                this.fields = new HashMap<String, Field>();
                this.numericFields = new HashMap<String, NumericField>();
                this.fields.put(DocMaker.BODY_FIELD, new Field(DocMaker.BODY_FIELD, "", bodyStore, bodyIndex, termVector));
                this.fields.put(DocMaker.TITLE_FIELD, new Field(DocMaker.TITLE_FIELD, "", store, index, termVector));
                this.fields.put(DocMaker.DATE_FIELD, new Field(DocMaker.DATE_FIELD, "", store, index, termVector));
                this.fields.put(DocMaker.ID_FIELD, new Field(DocMaker.ID_FIELD, "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                this.fields.put(DocMaker.NAME_FIELD, new Field(DocMaker.NAME_FIELD, "", store, index, termVector));
                this.numericFields.put(DocMaker.DATE_MSEC_FIELD, new NumericField(DocMaker.DATE_MSEC_FIELD));
                this.numericFields.put(DocMaker.TIME_SEC_FIELD, new NumericField(DocMaker.TIME_SEC_FIELD));
                this.doc = new Document();
            } else {
                this.numericFields = null;
                this.fields = null;
                this.doc = null;
            }
        }

        Field getField(String name, Field.Store store, Field.Index index, Field.TermVector termVector) {
            if (!this.reuseFields) {
                return new Field(name, "", store, index, termVector);
            }
            Field f = this.fields.get(name);
            if (f == null) {
                f = new Field(name, "", store, index, termVector);
                this.fields.put(name, f);
            }
            return f;
        }

        NumericField getNumericField(String name) {
            if (!this.reuseFields) {
                return new NumericField(name);
            }
            NumericField f = this.numericFields.get(name);
            if (f == null) {
                f = new NumericField(name);
                this.numericFields.put(name, f);
            }
            return f;
        }
    }

    private static class LeftOver {
        DocData docdata;
        int cnt;
    }
}

