/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.utils.Config;

public abstract class PerfTask
implements Cloneable {
    static final int DEFAULT_LOG_STEP = 1000;
    private PerfRunData runData;
    private String name = this.getClass().getSimpleName();
    private int depth = 0;
    protected int logStep;
    private int logStepCount = 0;
    private int maxDepthLogStart = 0;
    private boolean disableCounting = false;
    protected String params = null;
    private boolean runInBackground;
    private int deltaPri;
    protected static final String NEW_LINE = System.getProperty("line.separator");
    protected volatile boolean stopNow;

    private PerfTask() {
        if (this.name.endsWith("Task")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
    }

    public void setRunInBackground(int deltaPri) {
        this.runInBackground = true;
        this.deltaPri = deltaPri;
    }

    public boolean getRunInBackground() {
        return this.runInBackground;
    }

    public int getBackgroundDeltaPriority() {
        return this.deltaPri;
    }

    public void stopNow() {
        this.stopNow = true;
    }

    public PerfTask(PerfRunData runData) {
        this();
        this.runData = runData;
        Config config = runData.getConfig();
        this.maxDepthLogStart = config.get("task.max.depth.log", 0);
        String logStepAtt = "log.step";
        String taskLogStepAtt = "log.step." + this.name;
        if (config.get(taskLogStepAtt, null) != null) {
            logStepAtt = taskLogStepAtt;
        }
        this.logStep = config.get(logStepAtt, 1000);
        if (this.logStep <= 0) {
            this.logStep = Integer.MAX_VALUE;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void close() throws Exception {
    }

    public final int runAndMaybeStats(boolean reportStats) throws Exception {
        if (!reportStats || this.shouldNotRecordStats()) {
            this.setup();
            int count = this.doLogic();
            count = this.disableCounting ? 0 : count;
            this.tearDown();
            return count;
        }
        if (reportStats && this.depth <= this.maxDepthLogStart && !this.shouldNeverLogAtStart()) {
            System.out.println("------------> starting task: " + this.getName());
        }
        this.setup();
        Points pnts = this.runData.getPoints();
        TaskStats ts = pnts.markTaskStart(this, this.runData.getConfig().getRoundNumber());
        int count = this.doLogic();
        count = this.disableCounting ? 0 : count;
        pnts.markTaskEnd(ts, count);
        this.tearDown();
        return count;
    }

    public abstract int doLogic() throws Exception;

    public String getName() {
        if (this.params == null) {
            return this.name;
        }
        return this.name + '(' + this.params + ')';
    }

    protected void setName(String name) {
        this.name = name;
    }

    public PerfRunData getRunData() {
        return this.runData;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    String getPadding() {
        char[] c = new char[4 * this.getDepth()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = 32;
        }
        return new String(c);
    }

    public String toString() {
        String padd = this.getPadding();
        StringBuilder sb = new StringBuilder(padd);
        if (this.disableCounting) {
            sb.append('-');
        }
        sb.append(this.getName());
        if (this.getRunInBackground()) {
            sb.append(" &");
            int x = this.getBackgroundDeltaPriority();
            if (x != 0) {
                sb.append(x);
            }
        }
        return sb.toString();
    }

    int getMaxDepthLogStart() {
        return this.maxDepthLogStart;
    }

    protected String getLogMessage(int recsCount) {
        return "processed " + recsCount + " records";
    }

    protected boolean shouldNeverLogAtStart() {
        return false;
    }

    protected boolean shouldNotRecordStats() {
        return false;
    }

    public void setup() throws Exception {
    }

    public void tearDown() throws Exception {
        if (++this.logStepCount % this.logStep == 0) {
            double time = (double)(System.currentTimeMillis() - this.runData.getStartTimeMillis()) / 1000.0;
            System.out.println(String.format("%7.2f", time) + " sec --> " + Thread.currentThread().getName() + " " + this.getLogMessage(this.logStepCount));
        }
    }

    public boolean supportsParams() {
        return false;
    }

    public void setParams(String params) {
        if (!this.supportsParams()) {
            throw new UnsupportedOperationException(this.getName() + " does not support command line parameters.");
        }
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public boolean isDisableCounting() {
        return this.disableCounting;
    }

    public void setDisableCounting(boolean disableCounting) {
        this.disableCounting = disableCounting;
    }
}

