/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.stats;

public class TimeData {
    public String name;
    public long count = 0L;
    public long elapsed = 0L;
    private long delta = 0L;
    public long freeMem = 0L;
    public long totalMem = 0L;

    public TimeData() {
    }

    public TimeData(String name) {
        this.name = name;
    }

    public void start() {
        this.delta = System.currentTimeMillis();
    }

    public void stop() {
        ++this.count;
        this.elapsed += System.currentTimeMillis() - this.delta;
    }

    public void recordMemUsage() {
        this.freeMem = Runtime.getRuntime().freeMemory();
        this.totalMem = Runtime.getRuntime().totalMemory();
    }

    public void reset() {
        this.count = 0L;
        this.delta = this.elapsed = 0L;
    }

    protected Object clone() {
        TimeData td = new TimeData(this.name);
        td.name = this.name;
        td.elapsed = this.elapsed;
        td.count = this.count;
        td.delta = this.delta;
        td.freeMem = this.freeMem;
        td.totalMem = this.totalMem;
        return td;
    }

    public double getRate() {
        double rps = (double)this.count * 1000.0 / (double)(this.elapsed > 0L ? this.elapsed : 1L);
        return rps;
    }

    public static String getLabels() {
        return "# count\telapsed\trec/s\tfreeMem\ttotalMem";
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withMem) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.count + "\t" + this.elapsed + "\t" + this.getRate());
        if (withMem) {
            sb.append("\t" + this.freeMem + "\t" + this.totalMem);
        }
        return sb.toString();
    }
}

