/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class StreamUtils {
    public static final int BUFFER_SIZE = 65536;
    private static final Map<String, Type> extensionToType = new HashMap<String, Type>();

    public static InputStream inputStream(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), 65536);
        return StreamUtils.fileType(file).inputStream(in);
    }

    private static Type fileType(File file) {
        Type type = null;
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx != -1) {
            type = extensionToType.get(fileName.substring(idx).toLowerCase(Locale.ENGLISH));
        }
        return type == null ? Type.PLAIN : type;
    }

    private static InputStream closableCompressorInputStream(Type type, InputStream is) throws CompressorException {
        CompressorInputStream delegee = new CompressorStreamFactory().createCompressorInputStream(type.csfType, is);
        if (!Type.GZIP.equals((Object)type)) {
            return delegee;
        }
        return new InputStream((InputStream)delegee, is){
            final /* synthetic */ InputStream val$delegee;
            final /* synthetic */ InputStream val$is;
            {
                this.val$delegee = inputStream;
                this.val$is = inputStream2;
            }

            public int read() throws IOException {
                return this.val$delegee.read();
            }

            public int read(byte[] b) throws IOException {
                return this.val$delegee.read(b);
            }

            public int available() throws IOException {
                return this.val$delegee.available();
            }

            public synchronized void mark(int readlimit) {
                this.val$delegee.mark(readlimit);
            }

            public boolean markSupported() {
                return this.val$delegee.markSupported();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return this.val$delegee.read(b, off, len);
            }

            public synchronized void reset() throws IOException {
                this.val$delegee.reset();
            }

            public long skip(long n) throws IOException {
                return this.val$delegee.skip(n);
            }

            public void close() throws IOException {
                this.val$delegee.close();
                this.val$is.close();
            }
        };
    }

    public static OutputStream outputStream(File file) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), 65536);
        return StreamUtils.fileType(file).outputStream(os);
    }

    static {
        extensionToType.put(".bz2", Type.BZIP2);
        extensionToType.put(".bzip", Type.BZIP2);
        extensionToType.put(".gz", Type.GZIP);
        extensionToType.put(".gzip", Type.GZIP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BZIP2("bzip2"),
        GZIP("gz"),
        PLAIN(null);

        private final String csfType;

        private Type(String csfType) {
            this.csfType = csfType;
        }

        private InputStream inputStream(InputStream in) throws IOException {
            try {
                return this.csfType == null ? in : StreamUtils.closableCompressorInputStream(this, in);
            }
            catch (CompressorException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        private OutputStream outputStream(OutputStream os) throws IOException {
            try {
                return this.csfType == null ? os : new CompressorStreamFactory().createCompressorOutputStream(this.csfType, os);
            }
            catch (CompressorException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

