/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class SimpleQQParser
implements QualityQueryParser {
    private String qqName;
    private String indexField;
    ThreadLocal<QueryParser> queryParser = new ThreadLocal();

    public SimpleQQParser(String qqName, String indexField) {
        this.qqName = qqName;
        this.indexField = indexField;
    }

    public Query parse(QualityQuery qq) throws ParseException {
        QueryParser qp = this.queryParser.get();
        if (qp == null) {
            qp = new QueryParser(Version.LUCENE_CURRENT, this.indexField, (Analyzer)new StandardAnalyzer(Version.LUCENE_CURRENT));
            this.queryParser.set(qp);
        }
        return qp.parse(qq.getValue(this.qqName));
    }
}

