/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;

public class CreateIndexTask
extends PerfTask {
    public CreateIndexTask(PerfRunData runData) {
        super(runData);
    }

    public static void setIndexWriterConfig(IndexWriter writer, Config config) throws IOException {
        String mergeScheduler = config.get("merge.scheduler", "org.apache.lucene.index.ConcurrentMergeScheduler");
        try {
            writer.setMergeScheduler(Class.forName(mergeScheduler).asSubclass(MergeScheduler.class).newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate class '" + mergeScheduler + "' as merge scheduler", e);
        }
        String mergePolicy = config.get("merge.policy", "org.apache.lucene.index.LogByteSizeMergePolicy");
        try {
            writer.setMergePolicy(Class.forName(mergePolicy).asSubclass(MergePolicy.class).getConstructor(IndexWriter.class).newInstance(writer));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate class '" + mergePolicy + "' as merge policy", e);
        }
        writer.setUseCompoundFile(config.get("compound", true));
        writer.setMergeFactor(config.get("merge.factor", 10));
        writer.setMaxFieldLength(config.get("max.field.length", 10000));
        double ramBuffer = config.get("ram.flush.mb", 16.0);
        int maxBuffered = config.get("max.buffered", -1);
        if (maxBuffered == -1) {
            writer.setRAMBufferSizeMB(ramBuffer);
            writer.setMaxBufferedDocs(maxBuffered);
        } else {
            writer.setMaxBufferedDocs(maxBuffered);
            writer.setRAMBufferSizeMB(ramBuffer);
        }
        String infoStreamVal = config.get("writer.info.stream", null);
        if (infoStreamVal != null) {
            if (infoStreamVal.equals("SystemOut")) {
                writer.setInfoStream(System.out);
            } else if (infoStreamVal.equals("SystemErr")) {
                writer.setInfoStream(System.err);
            } else {
                File f = new File(infoStreamVal).getAbsoluteFile();
                writer.setInfoStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(f))));
            }
        }
    }

    public static IndexDeletionPolicy getIndexDeletionPolicy(Config config) {
        String deletionPolicyName = config.get("deletion.policy", "org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy");
        IndexDeletionPolicy indexDeletionPolicy = null;
        RuntimeException err = null;
        try {
            indexDeletionPolicy = Class.forName(deletionPolicyName).asSubclass(IndexDeletionPolicy.class).newInstance();
        }
        catch (IllegalAccessException iae) {
            err = new RuntimeException("unable to instantiate class '" + deletionPolicyName + "' as IndexDeletionPolicy");
            err.initCause(iae);
        }
        catch (InstantiationException ie) {
            err = new RuntimeException("unable to instantiate class '" + deletionPolicyName + "' as IndexDeletionPolicy");
            err.initCause(ie);
        }
        catch (ClassNotFoundException cnfe) {
            err = new RuntimeException("unable to load class '" + deletionPolicyName + "' as IndexDeletionPolicy");
            err.initCause(cnfe);
        }
        if (err != null) {
            throw err;
        }
        return indexDeletionPolicy;
    }

    public int doLogic() throws IOException {
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        IndexWriter writer = new IndexWriter(runData.getDirectory(), runData.getAnalyzer(), true, CreateIndexTask.getIndexDeletionPolicy(config), IndexWriter.MaxFieldLength.LIMITED);
        CreateIndexTask.setIndexWriterConfig(writer, config);
        runData.setIndexWriter(writer);
        return 1;
    }
}

