/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class CommitIndexTask
extends PerfTask {
    Map<String, String> commitUserData;

    public CommitIndexTask(PerfRunData runData) {
        super(runData);
    }

    public boolean supportsParams() {
        return true;
    }

    public void setParams(String params) {
        this.commitUserData = new HashMap<String, String>();
        this.commitUserData.put("userData", params);
    }

    public int doLogic() throws Exception {
        IndexWriter iw = this.getRunData().getIndexWriter();
        if (iw != null) {
            iw.commit(this.commitUserData);
        } else {
            IndexReader r = this.getRunData().getIndexReader();
            if (r != null) {
                r.commit(this.commitUserData);
                r.decRef();
            } else {
                throw new IllegalStateException("neither IndexWriter nor IndexReader is currently open");
            }
        }
        return 1;
    }
}

