/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.BenchmarkHighlighter;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;

public class SearchTravRetVectorHighlightTask
extends SearchTravTask {
    protected int numToHighlight = Integer.MAX_VALUE;
    protected int maxFrags = 2;
    protected int fragSize = 100;
    protected Set paramFields = Collections.EMPTY_SET;
    protected FastVectorHighlighter highlighter;

    public SearchTravRetVectorHighlightTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        PerfRunData data = this.getRunData();
        if (!data.getConfig().get("doc.stored", false)) {
            throw new Exception("doc.stored must be set to true");
        }
        if (!data.getConfig().get("doc.term.vector.offsets", false)) {
            throw new Exception("doc.term.vector.offsets must be set to true");
        }
        if (!data.getConfig().get("doc.term.vector.positions", false)) {
            throw new Exception("doc.term.vector.positions must be set to true");
        }
    }

    public boolean withRetrieve() {
        return true;
    }

    public int numToHighlight() {
        return this.numToHighlight;
    }

    protected BenchmarkHighlighter getBenchmarkHighlighter(Query q) {
        this.highlighter = new FastVectorHighlighter(false, false);
        final FieldQuery fq = this.highlighter.getFieldQuery(q);
        return new BenchmarkHighlighter(){

            public int doHighlight(IndexReader reader, int doc, String field, Document document, Analyzer analyzer, String text) throws Exception {
                String[] fragments = SearchTravRetVectorHighlightTask.this.highlighter.getBestFragments(fq, reader, doc, field, SearchTravRetVectorHighlightTask.this.fragSize, SearchTravRetVectorHighlightTask.this.maxFrags);
                return fragments != null ? fragments.length : 0;
            }
        };
    }

    protected Collection getFieldsToHighlight(Document document) {
        Collection result = super.getFieldsToHighlight(document);
        if (!this.paramFields.isEmpty() && !result.isEmpty()) {
            result.retainAll(this.paramFields);
        } else {
            result = this.paramFields;
        }
        return result;
    }

    public void setParams(String params) {
        String[] splits = params.split(",");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].startsWith("size[")) {
                this.traversalSize = (int)Float.parseFloat(splits[i].substring("size[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("highlight[")) {
                this.numToHighlight = (int)Float.parseFloat(splits[i].substring("highlight[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("maxFrags[")) {
                this.maxFrags = (int)Float.parseFloat(splits[i].substring("maxFrags[".length(), splits[i].length() - 1));
                continue;
            }
            if (splits[i].startsWith("fragSize[")) {
                this.fragSize = (int)Float.parseFloat(splits[i].substring("fragSize[".length(), splits[i].length() - 1));
                continue;
            }
            if (!splits[i].startsWith("fields[")) continue;
            this.paramFields = new HashSet();
            String fieldNames = splits[i].substring("fields[".length(), splits[i].length() - 1);
            String[] fieldSplits = fieldNames.split(";");
            for (int j = 0; j < fieldSplits.length; ++j) {
                this.paramFields.add(fieldSplits[j]);
            }
        }
    }
}

