/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Report;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.tasks.ReportTask;

public class RepSumByNameRoundTask
extends ReportTask {
    public RepSumByNameRoundTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        Report rp = this.reportSumByNameRound(this.getRunData().getPoints().taskStats());
        System.out.println();
        System.out.println("------------> Report Sum By (any) Name and Round (" + rp.getSize() + " about " + rp.getReported() + " out of " + rp.getOutOf() + ")");
        System.out.println(rp.getText());
        System.out.println();
        return 0;
    }

    protected Report reportSumByNameRound(List taskStats) {
        LinkedHashMap<String, TaskStats> p2 = new LinkedHashMap<String, TaskStats>();
        int reported = 0;
        for (TaskStats stat1 : taskStats) {
            if (stat1.getElapsed() < 0L) continue;
            ++reported;
            String name = stat1.getTask().getName();
            String rname = stat1.getRound() + "." + name;
            TaskStats stat2 = (TaskStats)p2.get(rname);
            if (stat2 == null) {
                try {
                    stat2 = (TaskStats)stat1.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
                p2.put(rname, stat2);
                continue;
            }
            stat2.add(stat1);
        }
        return this.genPartialReport(reported, p2, taskStats.size());
    }
}

