/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StringBufferReader;

public class TrecContentSource
extends ContentSource {
    private static final String DATE = "Date: ";
    private static final String DOCHDR = "<DOCHDR>";
    private static final String TERMINATING_DOCHDR = "</DOCHDR>";
    private static final String DOCNO = "<DOCNO>";
    private static final String TERMINATING_DOCNO = "</DOCNO>";
    private static final String DOC = "<DOC>";
    private static final String TERMINATING_DOC = "</DOC>";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy kk:mm:ss z", "EEE MMM dd kk:mm:ss yyyy z", "EEE, dd-MMM-':'y kk:mm:ss z", "EEE, dd-MMM-yyy kk:mm:ss z", "EEE MMM dd kk:mm:ss yyyy"};
    private ThreadLocal dateFormats = new ThreadLocal();
    private ThreadLocal trecDocReader = new ThreadLocal();
    private ThreadLocal trecDocBuffer = new ThreadLocal();
    private File dataDir = null;
    private ArrayList inputFiles = new ArrayList();
    private int nextFile = 0;
    private int rawDocSize;
    private Object lock = new Object();
    BufferedReader reader;
    int iteration = 0;
    HTMLParser htmlParser;

    private DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = (DateFormatInfo)this.dateFormats.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.dfs = new SimpleDateFormat[DATE_FORMATS.length];
            for (int i = 0; i < dfi.dfs.length; ++i) {
                dfi.dfs[i] = new SimpleDateFormat(DATE_FORMATS[i], Locale.US);
                dfi.dfs[i].setLenient(true);
            }
            dfi.pos = new ParsePosition(0);
            this.dateFormats.set(dfi);
        }
        return dfi;
    }

    private StringBuffer getDocBuffer() {
        StringBuffer sb = (StringBuffer)this.trecDocBuffer.get();
        if (sb == null) {
            sb = new StringBuffer();
            this.trecDocBuffer.set(sb);
        }
        return sb;
    }

    private Reader getTrecDocReader(StringBuffer docBuffer) {
        StringBufferReader r = (StringBufferReader)this.trecDocReader.get();
        if (r == null) {
            r = new StringBufferReader(docBuffer);
            this.trecDocReader.set(r);
        } else {
            r.set(docBuffer);
        }
        return r;
    }

    private void read(StringBuffer buf, String prefix, boolean collectMatchLine, boolean collectAll, String terminatingTag) throws IOException, NoMoreDataException {
        String sep = "";
        while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                this.openNextFile();
                continue;
            }
            this.rawDocSize += line.length();
            if (line.startsWith(prefix)) {
                if (!collectMatchLine) break;
                buf.append(sep).append(line);
                sep = NEW_LINE;
                break;
            }
            if (terminatingTag != null && line.startsWith(terminatingTag)) {
                buf.setLength(0);
                break;
            }
            if (!collectAll) continue;
            buf.append(sep).append(line);
            sep = NEW_LINE;
        }
    }

    void openNextFile() throws NoMoreDataException, IOException {
        this.close();
        int retries = 0;
        while (true) {
            if (this.nextFile >= this.inputFiles.size()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.nextFile = 0;
                ++this.iteration;
            }
            File f = (File)this.inputFiles.get(this.nextFile++);
            if (this.verbose) {
                System.out.println("opening: " + f + " length: " + f.length());
            }
            try {
                GZIPInputStream zis = new GZIPInputStream((InputStream)new FileInputStream(f), 65536);
                this.reader = new BufferedReader(new InputStreamReader((InputStream)zis, this.encoding), 65536);
                return;
            }
            catch (Exception e) {
                if (++retries < 20 && this.verbose) {
                    System.out.println("Skipping 'bad' file " + f.getAbsolutePath() + "  #retries=" + retries);
                    continue;
                }
                throw new NoMoreDataException();
            }
            break;
        }
    }

    Date parseDate(String dateStr) {
        dateStr = dateStr.trim();
        DateFormatInfo dfi = this.getDateFormatInfo();
        for (int i = 0; i < dfi.dfs.length; ++i) {
            DateFormat df = dfi.dfs[i];
            dfi.pos.setIndex(0);
            dfi.pos.setErrorIndex(-1);
            Date d = df.parse(dateStr, dfi.pos);
            if (d == null) continue;
            return d;
        }
        if (this.verbose) {
            System.out.println("failed to parse date (assigning 'now') for: " + dateStr);
        }
        return null;
    }

    public void close() throws IOException {
        block3: {
            if (this.reader == null) {
                return;
            }
            try {
                this.reader.close();
            }
            catch (IOException e) {
                if (!this.verbose) break block3;
                System.out.println("failed to close reader !");
                e.printStackTrace(System.out);
            }
        }
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        String dateStr = null;
        String name = null;
        Reader r = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.reader == null) {
                this.openNextFile();
            }
            StringBuffer docBuf = this.getDocBuffer();
            docBuf.setLength(0);
            this.read(docBuf, DOC, false, false, null);
            docBuf.setLength(0);
            this.read(docBuf, DOCNO, true, false, null);
            name = docBuf.substring(DOCNO.length(), docBuf.indexOf(TERMINATING_DOCNO, DOCNO.length()));
            name = name + "_" + this.iteration;
            docBuf.setLength(0);
            this.read(docBuf, DOCHDR, false, false, null);
            boolean findTerminatingDocHdr = false;
            docBuf.setLength(0);
            this.read(docBuf, DATE, true, false, TERMINATING_DOCHDR);
            if (docBuf.length() != 0) {
                dateStr = docBuf.substring(DATE.length());
                findTerminatingDocHdr = true;
            }
            if (findTerminatingDocHdr) {
                docBuf.setLength(0);
                this.read(docBuf, TERMINATING_DOCHDR, false, false, null);
            }
            docBuf.setLength(0);
            this.read(docBuf, TERMINATING_DOC, false, true, null);
            r = this.getTrecDocReader(docBuf);
            r.reset();
            this.addBytes(docBuf.length());
        }
        Date date = dateStr != null ? this.parseDate(dateStr) : null;
        try {
            docData = this.htmlParser.parse(docData, name, date, r, null);
            this.addDoc();
        }
        catch (InterruptedException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return docData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInputs() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.resetInputs();
            this.close();
            this.nextFile = 0;
            this.iteration = 0;
        }
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        File workDir = new File(config.get("work.dir", "work"));
        String d = config.get("docs.dir", "trec");
        this.dataDir = new File(d);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = new File(workDir, d);
        }
        this.collectFiles(this.dataDir, this.inputFiles);
        if (this.inputFiles.size() == 0) {
            throw new IllegalArgumentException("No files in dataDir: " + this.dataDir);
        }
        try {
            String parserClassName = config.get("html.parser", "org.apache.lucene.benchmark.byTask.feeds.DemoHTMLParser");
            this.htmlParser = (HTMLParser)Class.forName(parserClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
    }

    private static final class DateFormatInfo {
        DateFormat[] dfs;
        ParsePosition pos;

        private DateFormatInfo() {
        }
    }
}

