/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;

public abstract class ReadTask
extends PerfTask {
    public ReadTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        int res = 0;
        boolean closeReader = false;
        IndexReader ir = this.getRunData().getIndexReader();
        if (ir == null) {
            Directory dir = this.getRunData().getDirectory();
            ir = IndexReader.open((Directory)dir);
            closeReader = true;
        }
        if (this.withWarm()) {
            Document doc = null;
            for (int m = 0; m < ir.maxDoc(); ++m) {
                if (ir.isDeleted(m)) continue;
                doc = ir.document(m);
                res += doc == null ? 0 : 1;
            }
        }
        if (this.withSearch()) {
            int traversalSize;
            ++res;
            IndexSearcher searcher = new IndexSearcher(ir);
            QueryMaker queryMaker = this.getQueryMaker();
            Query q = queryMaker.makeQuery();
            Sort sort = this.getSort();
            Hits hits = sort != null ? searcher.search(q, sort) : searcher.search(q);
            if (this.withTraverse() && hits != null && (traversalSize = Math.min(hits.length(), this.traversalSize())) > 0) {
                boolean retrieve = this.withRetrieve();
                int numHighlight = Math.min(this.numToHighlight(), hits.length());
                Analyzer analyzer = this.getRunData().getAnalyzer();
                Highlighter highlighter = null;
                int maxFrags = 1;
                if (numHighlight > 0) {
                    highlighter = this.getHighlighter(q);
                    maxFrags = this.maxNumFragments();
                }
                boolean merge = this.isMergeContiguousFragments();
                for (int m = 0; m < traversalSize; ++m) {
                    int id = hits.id(m);
                    ++res;
                    if (!retrieve) continue;
                    Document document = this.retrieveDoc(ir, id);
                    res += document != null ? 1 : 0;
                    if (numHighlight <= 0 || m >= numHighlight) continue;
                    Collection fieldsToHighlight = this.getFieldsToHighlight(document);
                    Iterator iterator = fieldsToHighlight.iterator();
                    while (iterator.hasNext()) {
                        String field = (String)iterator.next();
                        String text = document.get(field);
                        TokenStream ts = TokenSources.getAnyTokenStream((IndexReader)ir, (int)id, (String)field, (Document)document, (Analyzer)analyzer);
                        res += this.doHighlight(ts, text, highlighter, merge, maxFrags);
                    }
                }
            }
            searcher.close();
        }
        if (closeReader) {
            ir.close();
        }
        return res;
    }

    protected Document retrieveDoc(IndexReader ir, int id) throws IOException {
        return ir.document(id);
    }

    public abstract QueryMaker getQueryMaker();

    public abstract boolean withSearch();

    public abstract boolean withWarm();

    public abstract boolean withTraverse();

    public int traversalSize() {
        return Integer.MAX_VALUE;
    }

    public abstract boolean withRetrieve();

    public int numToHighlight() {
        return 0;
    }

    protected Highlighter getHighlighter(Query q) {
        return new Highlighter((Formatter)new SimpleHTMLFormatter(), (Scorer)new QueryScorer(q));
    }

    public int maxNumFragments() {
        return 10;
    }

    public boolean isMergeContiguousFragments() {
        return false;
    }

    protected int doHighlight(TokenStream ts, String text, Highlighter highlighter, boolean mergeContiguous, int maxFragments) throws IOException {
        TextFragment[] frag = highlighter.getBestTextFragments(ts, text, mergeContiguous, maxFragments);
        return frag != null ? frag.length : 0;
    }

    protected Sort getSort() {
        return null;
    }

    protected Collection getFieldsToHighlight(Document document) {
        List fieldables = document.getFields();
        HashSet<String> result = new HashSet<String>(fieldables.size());
        Iterator iterator = fieldables.iterator();
        while (iterator.hasNext()) {
            Fieldable fieldable = (Fieldable)iterator.next();
            result.add(fieldable.name());
        }
        return result;
    }
}

