/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.utils.Format;

public abstract class PerfTask
implements Cloneable {
    private PerfRunData runData;
    private String name = Format.simpleName(this.getClass());
    private int depth = 0;
    private int maxDepthLogStart = 0;
    private boolean disableCounting = false;
    protected String params = null;
    protected static final String NEW_LINE = System.getProperty("line.separator");

    private PerfTask() {
        if (this.name.endsWith("Task")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
    }

    public PerfTask(PerfRunData runData) {
        this();
        this.runData = runData;
        this.maxDepthLogStart = runData.getConfig().get("task.max.depth.log", 0);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final int runAndMaybeStats(boolean reportStats) throws Exception {
        if (reportStats && this.depth <= this.maxDepthLogStart && !this.shouldNeverLogAtStart()) {
            System.out.println("------------> starting task: " + this.getName());
        }
        if (!reportStats || this.shouldNotRecordStats()) {
            this.setup();
            int count = this.doLogic();
            count = this.disableCounting ? 0 : count;
            this.tearDown();
            return count;
        }
        this.setup();
        Points pnts = this.runData.getPoints();
        TaskStats ts = pnts.markTaskStart(this, this.runData.getConfig().getRoundNumber());
        int count = this.doLogic();
        count = this.disableCounting ? 0 : count;
        pnts.markTaskEnd(ts, count);
        this.tearDown();
        return count;
    }

    public abstract int doLogic() throws Exception;

    public String getName() {
        if (this.params == null) {
            return this.name;
        }
        return this.name + '(' + this.params + ')';
    }

    protected void setName(String name) {
        this.name = name;
    }

    public PerfRunData getRunData() {
        return this.runData;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    String getPadding() {
        char[] c = new char[4 * this.getDepth()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = 32;
        }
        return new String(c);
    }

    public String toString() {
        String padd = this.getPadding();
        StringBuffer sb = new StringBuffer(padd);
        if (this.disableCounting) {
            sb.append('-');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    int getMaxDepthLogStart() {
        return this.maxDepthLogStart;
    }

    protected boolean shouldNeverLogAtStart() {
        return false;
    }

    protected boolean shouldNotRecordStats() {
        return false;
    }

    public void setup() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public boolean supportsParams() {
        return false;
    }

    public void setParams(String params) {
        if (!this.supportsParams()) {
            throw new UnsupportedOperationException(this.getName() + " does not support command line parameters.");
        }
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public boolean isDisableCounting() {
        return this.disableCounting;
    }

    public void setDisableCounting(boolean disableCounting) {
        this.disableCounting = disableCounting;
    }
}

