/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.text.NumberFormat;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;

public class AddDocTask
extends PerfTask {
    public static final int DEFAULT_ADD_DOC_LOG_STEP = 500;
    private int logStep = -1;
    private int docSize = 0;
    int count = 0;
    private Document doc = null;

    public AddDocTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = this.docSize > 0 ? docMaker.makeDocument(this.docSize) : docMaker.makeDocument();
    }

    public void tearDown() throws Exception {
        this.log(++this.count);
        this.doc = null;
        super.tearDown();
    }

    public int doLogic() throws Exception {
        this.getRunData().getIndexWriter().addDocument(this.doc);
        return 1;
    }

    private void log(int count) {
        if (this.logStep < 0) {
            this.logStep = this.getRunData().getConfig().get("doc.add.log.step", 500);
        }
        if (this.logStep > 0 && count % this.logStep == 0) {
            double seconds = (double)(System.currentTimeMillis() - this.getRunData().getStartTimeMillis()) / 1000.0;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            System.out.println("--> " + nf.format(seconds) + " sec: " + Thread.currentThread().getName() + " processed (add) " + count + " docs");
        }
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

