/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public class OpenIndexTask
extends PerfTask {
    public static final int DEFAULT_MAX_BUFFERED = -1;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MERGE_PFACTOR = 10;
    public static final double DEFAULT_RAM_FLUSH_MB = 16.0;
    public static final boolean DEFAULT_AUTO_COMMIT = true;

    public OpenIndexTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        Analyzer analyzer = this.getRunData().getAnalyzer();
        Config config = this.getRunData().getConfig();
        boolean cmpnd = config.get("compound", true);
        int mrgf = config.get("merge.factor", 10);
        int mxbf = config.get("max.buffered", -1);
        int mxfl = config.get("max.field.length", 10000);
        double flushAtRAMUsage = config.get("ram.flush.mb", 16.0);
        boolean autoCommit = config.get("autocommit", true);
        IndexWriter writer = new IndexWriter(dir, autoCommit, analyzer, false);
        writer.setRAMBufferSizeMB(flushAtRAMUsage);
        writer.setMaxBufferedDocs(mxbf);
        writer.setMaxFieldLength(mxfl);
        writer.setMergeFactor(mrgf);
        writer.setUseCompoundFile(cmpnd);
        if (flushAtRAMUsage > 0.0) {
            writer.setRAMBufferSizeMB(flushAtRAMUsage);
        }
        this.getRunData().setIndexWriter(writer);
        return 1;
    }
}

