/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public class CreateIndexTask
extends PerfTask {
    public CreateIndexTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        Analyzer analyzer = this.getRunData().getAnalyzer();
        Config config = this.getRunData().getConfig();
        boolean cmpnd = config.get("compound", true);
        int mrgf = config.get("merge.factor", 10);
        int mxbf = config.get("max.buffered", -1);
        int mxfl = config.get("max.field.length", 10000);
        double flushAtRAMUsage = config.get("ram.flush.mb", 16.0);
        boolean autoCommit = config.get("autocommit", true);
        IndexWriter iw = new IndexWriter(dir, autoCommit, analyzer, true);
        iw.setUseCompoundFile(cmpnd);
        iw.setMergeFactor(mrgf);
        iw.setMaxFieldLength(mxfl);
        iw.setRAMBufferSizeMB(flushAtRAMUsage);
        iw.setMaxBufferedDocs(mxbf);
        this.getRunData().setIndexWriter(iw);
        return 1;
    }
}

