/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.digester.Digester;
import org.apache.lucene.benchmark.BenchmarkOptions;
import org.apache.lucene.benchmark.Benchmarker;
import org.apache.lucene.benchmark.standard.StandardBenchmarker;
import org.apache.lucene.benchmark.stats.TestData;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Driver {
    private File workingDir;
    private Benchmarker benchmarker;
    private BenchmarkOptions options;

    public Driver() {
    }

    public Driver(Benchmarker benchmarker, BenchmarkOptions options) {
        this.benchmarker = benchmarker;
        this.options = options;
    }

    public Driver(File workingDir, InputSource inputSource) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("benchmark/benchmarker", "class", StandardBenchmarker.class);
        digester.addSetProperties("benchmark/benchmarker");
        digester.addSetNext("benchmark/benchmarker", "setBenchmarker");
        digester.addObjectCreate("benchmark/options", "class", BenchmarkOptions.class);
        digester.addSetProperties("benchmark/options");
        digester.addSetNext("benchmark/options", "setOptions");
        digester.push((Object)this);
        digester.parse(inputSource);
        this.workingDir = workingDir;
    }

    private void run() throws Exception {
        TestData[] data = this.benchmarker.benchmark(this.workingDir, this.options);
    }

    public Benchmarker getBenchmarker() {
        return this.benchmarker;
    }

    public void setBenchmarker(Benchmarker benchmarker) {
        this.benchmarker = benchmarker;
    }

    public BenchmarkOptions getOptions() {
        return this.options;
    }

    public void setOptions(BenchmarkOptions options) {
        this.options = options;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Driver.printHelp(args);
            System.exit(0);
        }
        File workingDir = new File(args[0]);
        File configFile = new File(args[1]);
        if (configFile.exists()) {
            try {
                Driver driver = new Driver(workingDir, new InputSource(new FileReader(configFile)));
                driver.run();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static void printHelp(String[] args) {
        System.out.println("Usage: java -cp [...] " + Driver.class.getName() + "<working dir> <config-file>");
    }
}

