/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.benchmark.byTask.tasks.SearchTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.FileUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class PerfRunData {
    private Points points;
    private Directory directory;
    private Analyzer analyzer;
    private DocMaker docMaker;
    private HTMLParser htmlParser;
    private HashMap readTaskQueryMaker;
    private Class qmkrClass;
    private IndexReader indexReader;
    private IndexWriter indexWriter;
    private Config config;
    private long startTimeMillis;

    public PerfRunData(Config config) throws Exception {
        this.config = config;
        this.analyzer = (Analyzer)Class.forName(config.get("analyzer", "org.apache.lucene.analysis.standard.StandardAnalyzer")).newInstance();
        this.docMaker = (DocMaker)Class.forName(config.get("doc.maker", "org.apache.lucene.benchmark.byTask.feeds.SimpleDocMaker")).newInstance();
        this.docMaker.setConfig(config);
        this.readTaskQueryMaker = new HashMap();
        this.qmkrClass = Class.forName(config.get("query.maker", "org.apache.lucene.benchmark.byTask.feeds.SimpleQueryMaker"));
        this.htmlParser = (HTMLParser)Class.forName(config.get("html.parser", "org.apache.lucene.benchmark.byTask.feeds.DemoHTMLParser")).newInstance();
        this.docMaker.setHTMLParser(this.htmlParser);
        this.reinit(false);
        this.points = new Points(config);
        if (Boolean.valueOf(config.get("log.queries", "false")).booleanValue()) {
            System.out.println("------------> queries:");
            System.out.println(this.getQueryMaker(new SearchTask(this)).printQueries());
        }
    }

    public void reinit(boolean eraseIndex) throws Exception {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
        if (this.directory != null) {
            this.directory.close();
        }
        if ("FSDirectory".equals(this.config.get("directory", "RAMDirectory"))) {
            File workDir = new File(this.config.get("work.dir", "work"));
            File indexDir = new File(workDir, "index");
            if (eraseIndex && indexDir.exists()) {
                FileUtils.fullyDelete(indexDir);
            }
            indexDir.mkdirs();
            this.directory = FSDirectory.getDirectory((File)indexDir);
        } else {
            this.directory = new RAMDirectory();
        }
        this.resetInputs();
        System.runFinalization();
        System.gc();
    }

    public long setStartTimeMillis() {
        this.startTimeMillis = System.currentTimeMillis();
        return this.startTimeMillis;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Points getPoints() {
        return this.points;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public void setIndexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public void setIndexWriter(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public DocMaker getDocMaker() {
        return this.docMaker;
    }

    public Config getConfig() {
        return this.config;
    }

    public void resetInputs() {
        this.docMaker.resetInputs();
        Iterator it = this.readTaskQueryMaker.values().iterator();
        while (it.hasNext()) {
            ((QueryMaker)it.next()).resetInputs();
        }
    }

    public QueryMaker getQueryMaker(ReadTask readTask) {
        Class<?> readTaskClass = readTask.getClass();
        QueryMaker qm = (QueryMaker)this.readTaskQueryMaker.get(readTaskClass);
        if (qm == null) {
            try {
                qm = (QueryMaker)this.qmkrClass.newInstance();
                qm.setConfig(this.config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.readTaskQueryMaker.put(readTaskClass, qm);
        }
        return qm;
    }

    public HTMLParser getHtmlParser() {
        return this.htmlParser;
    }
}

