/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class WriteLineDocTask
extends PerfTask {
    public static final int DEFAULT_WRITELINE_DOC_LOG_STEP = 1000;
    private int logStep = -1;
    private int docSize = 0;
    int count = 0;
    private BufferedWriter lineFileOut = null;
    private DocMaker docMaker;
    public static final String SEP = "\t";

    public WriteLineDocTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        if (this.lineFileOut == null) {
            Config config = this.getRunData().getConfig();
            String fileName = config.get("line.file.out", null);
            if (fileName == null) {
                throw new Exception("line.file.out must be set");
            }
            this.lineFileOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
        }
        this.docMaker = this.getRunData().getDocMaker();
    }

    public void tearDown() throws Exception {
        this.log(++this.count);
        super.tearDown();
    }

    public int doLogic() throws Exception {
        Document doc = this.docSize > 0 ? this.docMaker.makeDocument(this.docSize) : this.docMaker.makeDocument();
        Field f = doc.getField("body");
        String body = f != null ? f.stringValue().replace('\t', ' ') : null;
        f = doc.getField("doctitle");
        String title = f != null ? f.stringValue().replace('\t', ' ') : "";
        f = doc.getField("docdate");
        String date = f != null ? f.stringValue().replace('\t', ' ') : "";
        if (body != null) {
            this.lineFileOut.write(title, 0, title.length());
            this.lineFileOut.write(SEP);
            this.lineFileOut.write(date, 0, date.length());
            this.lineFileOut.write(SEP);
            this.lineFileOut.write(body, 0, body.length());
            this.lineFileOut.newLine();
            this.lineFileOut.flush();
        }
        return 1;
    }

    private void log(int count) {
        if (this.logStep < 0) {
            this.logStep = this.getRunData().getConfig().get("doc.writeline.log.step", 1000);
        }
        if (this.logStep > 0 && count % this.logStep == 0) {
            System.out.println("--> " + Thread.currentThread().getName() + " processed (add) " + count + " docs");
        }
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

