/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.stats;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.lucene.benchmark.stats.MemUsage;
import org.apache.lucene.benchmark.stats.TimeData;

public class TestRunData {
    private String id;
    private long start = 0L;
    private long end = 0L;
    private LinkedHashMap data = new LinkedHashMap();

    public TestRunData() {
    }

    public TestRunData(String id) {
        this.id = id;
    }

    public LinkedHashMap getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public void startRun() {
        this.start = System.currentTimeMillis();
    }

    public void endRun() {
        this.end = System.currentTimeMillis();
    }

    public void addData(TimeData td) {
        td.recordMemUsage();
        Vector<Object> v = (Vector<Object>)this.data.get(td.name);
        if (v == null) {
            v = new Vector<Object>();
            this.data.put(td.name, v);
        }
        v.add(td.clone());
    }

    public Collection getLabels() {
        return this.data.keySet();
    }

    public TimeData getTotals(String label) {
        Vector v = (Vector)this.data.get(label);
        if (v == null) {
            return null;
        }
        TimeData res = new TimeData("TOTAL " + label);
        for (int i = 0; i < v.size(); ++i) {
            TimeData td = (TimeData)v.get(i);
            res.count += td.count;
            res.elapsed += td.elapsed;
        }
        return res;
    }

    public Vector getTotals() {
        Collection labels = this.getLabels();
        Vector<TimeData> v = new Vector<TimeData>();
        Iterator it = labels.iterator();
        while (it.hasNext()) {
            TimeData td = this.getTotals((String)it.next());
            v.add(td);
        }
        return v;
    }

    public MemUsage getMemUsage(String label) {
        Vector v = (Vector)this.data.get(label);
        if (v == null) {
            return null;
        }
        MemUsage res = new MemUsage();
        res.minFree = Long.MAX_VALUE;
        res.minTotal = Long.MAX_VALUE;
        long avgFree = 0L;
        long avgTotal = 0L;
        for (int i = 0; i < v.size(); ++i) {
            TimeData td = (TimeData)v.get(i);
            if (res.maxFree < td.freeMem) {
                res.maxFree = td.freeMem;
            }
            if (res.maxTotal < td.totalMem) {
                res.maxTotal = td.totalMem;
            }
            if (res.minFree > td.freeMem) {
                res.minFree = td.freeMem;
            }
            if (res.minTotal > td.totalMem) {
                res.minTotal = td.totalMem;
            }
            avgFree += td.freeMem;
            avgTotal += td.totalMem;
        }
        res.avgFree = avgFree / (long)v.size();
        res.avgTotal = avgTotal / (long)v.size();
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Collection labels = this.getLabels();
        Iterator it = labels.iterator();
        while (it.hasNext()) {
            String label = (String)it.next();
            sb.append(this.id).append("-").append(label).append(" ").append(this.getTotals(label).toString(false)).append(" ");
            sb.append(this.getMemUsage(label).toScaledString(0x100000, "MB")).append("\n");
        }
        return sb.toString();
    }
}

