/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public class OpenIndexTask
extends PerfTask {
    public static final int DEFAULT_MAX_BUFFERED = 10;
    public static final int DEFAULT_MERGE_PFACTOR = 10;

    public OpenIndexTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        Analyzer analyzer = this.getRunData().getAnalyzer();
        IndexWriter writer = new IndexWriter(dir, analyzer, false);
        Config config = this.getRunData().getConfig();
        boolean cmpnd = config.get("compound", true);
        int mrgf = config.get("merge.factor", 10);
        int mxbf = config.get("max.buffered", 10);
        writer.setMaxBufferedDocs(mxbf);
        writer.setMergeFactor(mrgf);
        writer.setUseCompoundFile(cmpnd);
        this.getRunData().setIndexWriter(writer);
        return 1;
    }
}

