/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class DeleteDocTask
extends PerfTask {
    public static final int DEFAULT_DOC_DELETE_STEP = 8;
    public static final int DEFAULT_DELETE_DOC_LOG_STEP = 500;
    private static int logStep = -1;
    private static int deleteStep = -1;
    private static int numDeleted = 0;
    private static int lastDeleted = -1;
    private int docid = -1;
    private boolean byStep = true;

    public DeleteDocTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        this.getRunData().getIndexReader().deleteDocument(this.docid);
        lastDeleted = this.docid;
        return 1;
    }

    public void setup() throws Exception {
        super.setup();
        if (logStep < 0) {
            logStep = this.getRunData().getConfig().get("doc.delete.log.step", 500);
        }
        if (deleteStep < 0) {
            deleteStep = this.getRunData().getConfig().get("doc.delete.step", 8);
        }
        this.docid = this.byStep ? lastDeleted + deleteStep : this.docid;
    }

    public void tearDown() throws Exception {
        this.log(++numDeleted);
        super.tearDown();
    }

    private void log(int count) {
        if (logStep > 0 && count % logStep == 0) {
            System.out.println("--> processed (delete) " + count + " docs, last deleted: " + lastDeleted);
        }
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docid = (int)Float.parseFloat(params);
        this.byStep = this.docid < 0;
    }

    public boolean supportsParams() {
        return true;
    }
}

