/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.Format;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public abstract class BasicDocMaker
implements DocMaker {
    private int numDocsCreated = 0;
    private boolean storeBytes = false;
    protected boolean forever;
    private ThreadLocal leftovr = new ThreadLocal();
    static final String BODY_FIELD = "body";
    private long numBytes = 0L;
    private long numUniqueBytes = 0L;
    protected Config config;
    protected Field.Store storeVal = Field.Store.NO;
    protected Field.Index indexVal = Field.Index.TOKENIZED;
    protected Field.TermVector termVecVal = Field.TermVector.NO;
    private int lastPrintedNumUniqueTexts = 0;
    private long lastPrintedNumUniqueBytes = 0L;
    private int printNum = 0;
    private HTMLParser htmlParser;

    private synchronized int incrNumDocsCreated() {
        return this.numDocsCreated++;
    }

    protected abstract DocData getNextDocData() throws NoMoreDataException, Exception;

    public Document makeDocument() throws Exception {
        this.resetLeftovers();
        DocData docData = this.getNextDocData();
        Document doc = this.createDocument(docData, 0, -1);
        return doc;
    }

    private Document createDocument(DocData docData, int size, int cnt) throws UnsupportedEncodingException {
        int docid = this.incrNumDocsCreated();
        Document doc = new Document();
        doc.add((Fieldable)new Field("docid", "doc" + docid, this.storeVal, this.indexVal, this.termVecVal));
        if (docData.getName() != null) {
            String name = cnt < 0 ? docData.getName() : docData.getName() + "_" + cnt;
            doc.add((Fieldable)new Field("docname", name, this.storeVal, this.indexVal, this.termVecVal));
        }
        if (docData.getDate() != null) {
            String dateStr = DateTools.dateToString((Date)docData.getDate(), (DateTools.Resolution)DateTools.Resolution.SECOND);
            doc.add((Fieldable)new Field("docdate", dateStr, this.storeVal, this.indexVal, this.termVecVal));
        }
        if (docData.getTitle() != null) {
            doc.add((Fieldable)new Field("doctitle", docData.getTitle(), this.storeVal, this.indexVal, this.termVecVal));
        }
        if (docData.getBody() != null && docData.getBody().length() > 0) {
            String bdy;
            if (size <= 0 || size >= docData.getBody().length()) {
                bdy = docData.getBody();
                docData.setBody("");
            } else {
                for (int n = size - 1; n < size + 20 && n < docData.getBody().length(); ++n) {
                    if (!Character.isWhitespace(docData.getBody().charAt(n))) continue;
                    size = n;
                    break;
                }
                bdy = docData.getBody().substring(0, size);
                docData.setBody(docData.getBody().substring(size));
            }
            doc.add((Fieldable)new Field(BODY_FIELD, bdy, this.storeVal, this.indexVal, this.termVecVal));
            if (this.storeBytes) {
                doc.add((Fieldable)new Field("bytes", bdy.getBytes("UTF-8"), Field.Store.YES));
            }
        }
        if (docData.getProps() != null) {
            Iterator<Object> it = docData.getProps().keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)docData.getProps().get(key);
                doc.add((Fieldable)new Field(key, val, this.storeVal, this.indexVal, this.termVecVal));
            }
            docData.setProps(null);
        }
        return doc;
    }

    public Document makeDocument(int size) throws Exception {
        int cnt;
        LeftOver lvr = (LeftOver)this.leftovr.get();
        if (lvr == null || lvr.docdata == null || lvr.docdata.getBody() == null || lvr.docdata.getBody().length() == 0) {
            this.resetLeftovers();
        }
        DocData dd = lvr == null ? this.getNextDocData() : lvr.docdata;
        int n = cnt = lvr == null ? 0 : lvr.cnt;
        while (dd.getBody() == null || dd.getBody().length() < size) {
            DocData dd2 = dd;
            dd = this.getNextDocData();
            cnt = 0;
            dd.setBody(dd2.getBody() + dd.getBody());
        }
        Document doc = this.createDocument(dd, size, cnt);
        if (dd.getBody() == null || dd.getBody().length() == 0) {
            this.resetLeftovers();
        } else {
            if (lvr == null) {
                lvr = new LeftOver();
                this.leftovr.set(lvr);
            }
            lvr.docdata = dd;
            lvr.cnt = ++cnt;
        }
        return doc;
    }

    private void resetLeftovers() {
        this.leftovr.set(null);
    }

    public void setConfig(Config config) {
        this.config = config;
        boolean stored = config.get("doc.stored", false);
        boolean tokenized = config.get("doc.tokenized", true);
        boolean termVec = config.get("doc.term.vector", false);
        this.storeVal = stored ? Field.Store.YES : Field.Store.NO;
        this.indexVal = tokenized ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED;
        this.termVecVal = termVec ? Field.TermVector.YES : Field.TermVector.NO;
        this.storeBytes = config.get("doc.store.body.bytes", false);
        this.forever = config.get("doc.maker.forever", true);
    }

    public synchronized void resetInputs() {
        this.printDocStatistics();
        this.numBytes = 0L;
        this.numDocsCreated = 0;
        this.resetLeftovers();
    }

    public long numUniqueBytes() {
        return this.numUniqueBytes;
    }

    public synchronized int getCount() {
        return this.numDocsCreated;
    }

    public synchronized long getByteCount() {
        return this.numBytes;
    }

    protected void addUniqueBytes(long n) {
        this.numUniqueBytes += n;
    }

    protected synchronized void addBytes(long n) {
        this.numBytes += n;
    }

    public void printDocStatistics() {
        long nub;
        boolean print = false;
        String col = "                  ";
        StringBuffer sb = new StringBuffer();
        String newline = System.getProperty("line.separator");
        sb.append("------------> ").append(Format.simpleName(this.getClass())).append(" statistics (").append(this.printNum).append("): ").append(newline);
        int nut = this.numUniqueTexts();
        if (nut > this.lastPrintedNumUniqueTexts) {
            print = true;
            sb.append("total count of unique texts: ").append(Format.format(0, nut, col)).append(newline);
            this.lastPrintedNumUniqueTexts = nut;
        }
        if ((nub = this.numUniqueBytes()) > this.lastPrintedNumUniqueBytes) {
            print = true;
            sb.append("total bytes of unique texts: ").append(Format.format(0, nub, col)).append(newline);
            this.lastPrintedNumUniqueBytes = nub;
        }
        if (this.getCount() > 0) {
            print = true;
            sb.append("num docs added since last inputs reset:   ").append(Format.format(0, this.getCount(), col)).append(newline);
            sb.append("total bytes added since last inputs reset: ").append(Format.format(0, this.getByteCount(), col)).append(newline);
        }
        if (print) {
            System.out.println(sb.append(newline).toString());
            ++this.printNum;
        }
    }

    protected void collectFiles(File f, ArrayList inputFiles) {
        if (!f.canRead()) {
            return;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.collectFiles(files[i], inputFiles);
            }
            return;
        }
        inputFiles.add(f);
        this.addUniqueBytes(f.length());
    }

    public void setHTMLParser(HTMLParser htmlParser) {
        this.htmlParser = htmlParser;
    }

    public HTMLParser getHtmlParser() {
        return this.htmlParser;
    }

    private static class LeftOver {
        private DocData docdata;
        private int cnt;

        private LeftOver() {
        }
    }
}

