/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.je.File;
import org.apache.lucene.store.je.JEIndexInput;
import org.apache.lucene.store.je.JEIndexOutput;
import org.apache.lucene.store.je.JELock;

public class JEDirectory
extends Directory {
    protected Set openFiles = Collections.synchronizedSet(new HashSet());
    protected Database files;
    protected Database blocks;
    protected Transaction txn;
    protected int flags;

    public JEDirectory(Transaction txn, Database files, Database blocks, int flags) {
        this.txn = txn;
        this.files = files;
        this.blocks = blocks;
        this.flags = flags;
    }

    public JEDirectory(Transaction txn, Database files, Database blocks) {
        this(txn, files, blocks, 0);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        Iterator iterator = this.openFiles.iterator();
        while (iterator.hasNext()) {
            System.out.println(((JEIndexOutput)((Object)iterator.next())).file.getName());
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        return new JEIndexOutput(this, name, true);
    }

    public void deleteFile(String name) throws IOException {
        new File(name).delete(this);
    }

    public boolean fileExists(String name) throws IOException {
        return new File(name).exists(this);
    }

    public long fileLength(String name) throws IOException {
        File file = new File(name);
        if (file.exists(this)) {
            return file.getLength();
        }
        throw new IOException("File does not exist: " + name);
    }

    public long fileModified(String name) throws IOException {
        File file = new File(name);
        if (file.exists(this)) {
            return file.getTimeModified();
        }
        throw new IOException("File does not exist: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws IOException {
        Cursor cursor = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                DatabaseEntry key = new DatabaseEntry(new byte[0]);
                DatabaseEntry data = new DatabaseEntry(null);
                data.setPartial(true);
                cursor = this.files.openCursor(this.txn, null);
                if (cursor.getNext(key, data, null) != OperationStatus.NOTFOUND) {
                    ByteArrayInputStream buffer = new ByteArrayInputStream(key.getData());
                    DataInputStream in = new DataInputStream(buffer);
                    String name = in.readUTF();
                    in.close();
                    list.add(name);
                    while (cursor.getNext(key, data, null) != OperationStatus.NOTFOUND) {
                        buffer = new ByteArrayInputStream(key.getData());
                        in = new DataInputStream(buffer);
                        name = in.readUTF();
                        in.close();
                        list.add(name);
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
        return list.toArray(new String[list.size()]);
    }

    public IndexInput openInput(String name) throws IOException {
        return new JEIndexInput(this, name);
    }

    public Lock makeLock(String name) {
        return new JELock();
    }

    public void renameFile(String from, String to) throws IOException {
        new File(from).rename(this, to);
    }

    public void touchFile(String name) throws IOException {
        File file = new File(name);
        long length = 0L;
        if (file.exists(this)) {
            length = file.getLength();
        }
        file.modify(this, length, System.currentTimeMillis());
    }

    public void setTransaction(Transaction txn) {
        this.txn = txn;
    }
}

