/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.je;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import org.apache.lucene.store.je.File;
import org.apache.lucene.store.je.JEDirectory;

public class Block {
    protected DatabaseEntry key;
    protected DatabaseEntry data;

    protected Block(File file) throws IOException {
        byte[] fileKey = file.getKey();
        this.key = new DatabaseEntry(new byte[fileKey.length + 8]);
        this.data = new DatabaseEntry(new byte[16384]);
        System.arraycopy(fileKey, 0, this.key.getData(), 0, fileKey.length);
        this.seek(0L);
    }

    protected byte[] getKey() {
        return this.key.getData();
    }

    protected byte[] getData() {
        return this.data.getData();
    }

    protected void seek(long position) throws IOException {
        byte[] data = this.key.getData();
        int index = data.length - 8;
        data[index + 0] = (byte)(0xFFL & (position >>>= 14) >>> 56);
        data[index + 1] = (byte)(0xFFL & position >>> 48);
        data[index + 2] = (byte)(0xFFL & position >>> 40);
        data[index + 3] = (byte)(0xFFL & position >>> 32);
        data[index + 4] = (byte)(0xFFL & position >>> 24);
        data[index + 5] = (byte)(0xFFL & position >>> 16);
        data[index + 6] = (byte)(0xFFL & position >>> 8);
        data[index + 7] = (byte)(0xFFL & position >>> 0);
    }

    protected void get(JEDirectory directory) throws IOException {
        try {
            directory.blocks.get(directory.txn, this.key, this.data, null);
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void put(JEDirectory directory) throws IOException {
        try {
            directory.blocks.put(directory.txn, this.key, this.data);
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
    }
}

