/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene95;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.HnswGraphProvider;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;

public final class Lucene95HnswVectorsReader
extends KnnVectorsReader
implements HnswGraphProvider {
    private final FieldInfos fieldInfos;
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene95HnswVectorsReader(SegmentReadState state) throws IOException {
        this.fieldInfos = state.fieldInfos;
        int versionMeta = this.readMetadata(state);
        boolean success = false;
        try {
            this.vectorData = Lucene95HnswVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene95HnswVectorsFormatData");
            this.vectorIndex = Lucene95HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene95HnswVectorsFormatIndex");
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"Lucene95HnswVectorsFormatMeta", (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        int byteSize = switch (info.getVectorEncoding()) {
            default -> throw new MatchException(null, null);
            case VectorEncoding.BYTE -> 1;
            case VectorEncoding.FLOAT32 -> 4;
        };
        long vectorBytes = Math.multiplyExact((long)dimension, byteSize);
        long numBytes = Math.multiplyExact(vectorBytes, fieldEntry.size);
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size + " * dim=" + dimension + " * byteSize=" + byteSize + " = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private VectorEncoding readVectorEncoding(DataInput input) throws IOException {
        int encodingId = input.readInt();
        if (encodingId < 0 || encodingId >= VectorEncoding.values().length) {
            throw new CorruptIndexException("Invalid vector encoding id: " + encodingId, input);
        }
        return VectorEncoding.values()[encodingId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = this.readVectorEncoding((DataInput)input);
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, vectorEncoding, info.getVectorSimilarityFunction());
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.vectorData);
        CodecUtil.checksumEntireFile((IndexInput)this.vectorIndex);
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fieldEntry.vectorEncoding) + " expected: " + String.valueOf(VectorEncoding.FLOAT32));
        }
        return OffHeapFloatVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.defaultFlatVectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDocVectorValues, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fieldEntry.vectorEncoding) + " expected: " + String.valueOf(VectorEncoding.BYTE));
        }
        return OffHeapByteVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.defaultFlatVectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDocVectorValues, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0 || knnCollector.k() == 0 || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = OffHeapFloatVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.defaultFlatVectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDocVectorValues, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
        RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)vectorValues, target);
        HnswGraphSearcher.search((RandomVectorScorer)scorer, (KnnCollector)new OrdinalTranslatedKnnCollector(knnCollector, arg_0 -> ((OffHeapFloatVectorValues)vectorValues).ordToDoc(arg_0)), (HnswGraph)this.getGraph(fieldEntry), (Bits)vectorValues.getAcceptOrds(acceptDocs));
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0 || knnCollector.k() == 0 || fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            return;
        }
        OffHeapByteVectorValues vectorValues = OffHeapByteVectorValues.load((VectorSimilarityFunction)fieldEntry.similarityFunction, (FlatVectorsScorer)this.defaultFlatVectorScorer, (OrdToDocDISIReaderConfiguration)fieldEntry.ordToDocVectorValues, (VectorEncoding)fieldEntry.vectorEncoding, (int)fieldEntry.dimension, (long)fieldEntry.vectorDataOffset, (long)fieldEntry.vectorDataLength, (IndexInput)this.vectorData);
        RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)vectorValues, target);
        HnswGraphSearcher.search((RandomVectorScorer)scorer, (KnnCollector)new OrdinalTranslatedKnnCollector(knnCollector, arg_0 -> ((OffHeapByteVectorValues)vectorValues).ordToDoc(arg_0)), (HnswGraph)this.getGraph(fieldEntry), (Bits)vectorValues.getAcceptOrds(acceptDocs));
    }

    public HnswGraph getGraph(String field) throws IOException {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null) {
            throw new IllegalArgumentException("No such field '" + field + "'");
        }
        FieldEntry entry = this.fields.get(field);
        if (entry != null && entry.vectorIndexLength > 0L) {
            return this.getGraph(entry);
        }
        return HnswGraph.EMPTY;
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        return new OffHeapHnswGraph(entry, this.vectorIndex);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorData, this.vectorIndex});
    }

    record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, int M, int numLevels, int dimension, int size, int[][] nodesByLevel, DirectMonotonicReader.Meta offsetsMeta, long offsetsOffset, int offsetsBlockShift, long offsetsLength, OrdToDocDISIReaderConfiguration ordToDocVectorValues) {
        static FieldEntry create(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            long offsetsLength;
            DirectMonotonicReader.Meta offsetsMeta;
            int offsetsBlockShift;
            long offsetsOffset;
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            long vectorIndexOffset = input.readVLong();
            long vectorIndexLength = input.readVLong();
            int dimension = input.readVInt();
            int size = input.readInt();
            OrdToDocDISIReaderConfiguration ordToDocVectorValues = OrdToDocDISIReaderConfiguration.fromStoredMeta((IndexInput)input, (int)size);
            int M = input.readVInt();
            int numLevels = input.readVInt();
            int[][] nodesByLevel = new int[numLevels][];
            long numberOfOffsets = 0L;
            for (int level = 0; level < numLevels; ++level) {
                if (level > 0) {
                    int numNodesOnLevel = input.readVInt();
                    numberOfOffsets += (long)numNodesOnLevel;
                    nodesByLevel[level] = new int[numNodesOnLevel];
                    nodesByLevel[level][0] = input.readVInt();
                    for (int i = 1; i < numNodesOnLevel; ++i) {
                        nodesByLevel[level][i] = nodesByLevel[level][i - 1] + input.readVInt();
                    }
                    continue;
                }
                numberOfOffsets += (long)size;
            }
            if (numberOfOffsets > 0L) {
                offsetsOffset = input.readLong();
                offsetsBlockShift = input.readVInt();
                offsetsMeta = DirectMonotonicReader.loadMeta((IndexInput)input, (long)numberOfOffsets, (int)offsetsBlockShift);
                offsetsLength = input.readLong();
            } else {
                offsetsOffset = 0L;
                offsetsBlockShift = 0;
                offsetsMeta = null;
                offsetsLength = 0L;
            }
            return new FieldEntry(similarityFunction, vectorEncoding, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, M, numLevels, dimension, size, nodesByLevel, offsetsMeta, offsetsOffset, offsetsBlockShift, offsetsLength, ordToDocVectorValues);
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        int arcCount;
        int arcUpTo;
        int arc;
        private final DirectMonotonicReader graphLevelNodeOffsets;
        private final long[] graphLevelNodeIndexOffsets;
        private int[] currentNeighborsBuffer;

        OffHeapHnswGraph(FieldEntry entry, IndexInput vectorIndex) throws IOException {
            this.dataIn = vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            RandomAccessInput addressesData = vectorIndex.randomAccessSlice(entry.offsetsOffset, entry.offsetsLength);
            this.graphLevelNodeOffsets = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)entry.offsetsMeta, (RandomAccessInput)addressesData);
            this.currentNeighborsBuffer = new int[entry.M * 2];
            this.graphLevelNodeIndexOffsets = new long[this.numLevels];
            this.graphLevelNodeIndexOffsets[0] = 0L;
            for (int i = 1; i < this.numLevels; ++i) {
                int nodeCount = this.nodesByLevel[i - 1] == null ? this.size : this.nodesByLevel[i - 1].length;
                this.graphLevelNodeIndexOffsets[i] = this.graphLevelNodeIndexOffsets[i - 1] + (long)nodeCount;
            }
        }

        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            this.dataIn.seek(this.graphLevelNodeOffsets.get((long)targetIndex + this.graphLevelNodeIndexOffsets[level]));
            this.arcCount = this.dataIn.readVInt();
            if (this.arcCount > 0) {
                if (this.arcCount > this.currentNeighborsBuffer.length) {
                    this.currentNeighborsBuffer = ArrayUtil.grow((int[])this.currentNeighborsBuffer, (int)this.arcCount);
                }
                this.currentNeighborsBuffer[0] = this.dataIn.readVInt();
                for (int i = 1; i < this.arcCount; ++i) {
                    this.currentNeighborsBuffer[i] = this.currentNeighborsBuffer[i - 1] + this.dataIn.readVInt();
                }
            }
            this.arc = -1;
            this.arcUpTo = 0;
        }

        public int size() {
            return this.size;
        }

        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            this.arc = this.currentNeighborsBuffer[this.arcUpTo];
            ++this.arcUpTo;
            return this.arc;
        }

        public int numLevels() throws IOException {
            return this.numLevels;
        }

        public int entryNode() throws IOException {
            return this.entryNode;
        }

        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }
}

