/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SplittableRandom;
import org.apache.lucene.backward_codecs.lucene90.Lucene90OnHeapHnswGraph;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class Lucene90HnswVectorsReader
extends KnnVectorsReader {
    private final Map<String, FieldEntry> fields;
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final long checksumSeed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene90HnswVectorsReader(SegmentReadState state) throws IOException {
        long[] checksumRef;
        block3: {
            this.fields = new HashMap<String, FieldEntry>();
            int versionMeta = this.readMetadata(state);
            checksumRef = new long[1];
            boolean success = false;
            try {
                this.vectorData = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene90HnswVectorsFormatData", checksumRef);
                this.vectorIndex = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene90HnswVectorsFormatIndex", checksumRef);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
        }
        this.checksumSeed = checksumRef[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"Lucene90HnswVectorsFormatMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, long[] checksumRef) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                checksumRef[0] = CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create((DataInput)input, info.getVectorSimilarityFunction());
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.vectorData);
        CodecUtil.checksumEntireFile((IndexInput)this.vectorIndex);
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        return this.getOffHeapVectorValues(fieldEntry);
    }

    public ByteVectorValues getByteVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = this.getOffHeapVectorValues(fieldEntry);
        SplittableRandom random = new SplittableRandom(this.checksumSeed);
        NeighborQueue results = Lucene90OnHeapHnswGraph.search(target, knnCollector.k(), knnCollector.k(), vectorValues, fieldEntry.similarityFunction, this.getGraphValues(fieldEntry), this.getAcceptOrds(acceptDocs, fieldEntry), knnCollector.visitLimit(), random);
        knnCollector.incVisitedCount(results.visitedCount());
        while (results.size() > 0) {
            int node = results.topNode();
            float minSimilarity = results.topScore();
            results.pop();
            knnCollector.collect(node, minSimilarity);
        }
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    private OffHeapFloatVectorValues getOffHeapVectorValues(FieldEntry fieldEntry) throws IOException {
        IndexInput bytesSlice = this.vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new OffHeapFloatVectorValues(fieldEntry.dimension, fieldEntry.ordToDoc, fieldEntry.similarityFunction, bytesSlice);
    }

    private Bits getAcceptOrds(final Bits acceptDocs, final FieldEntry fieldEntry) {
        if (acceptDocs == null) {
            return null;
        }
        return new Bits(){

            public boolean get(int index) {
                return acceptDocs.get(fieldEntry.ordToDoc[index]);
            }

            public int length() {
                return fieldEntry.ordToDoc.length;
            }
        };
    }

    private HnswGraph getGraphValues(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.indexDataOffset, entry.indexDataLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorData, this.vectorIndex});
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, long vectorDataOffset, long vectorDataLength, long indexDataOffset, long indexDataLength, int dimension, int[] ordToDoc, long[] ordOffsets) {
        static FieldEntry create(DataInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            long indexDataOffset = input.readVLong();
            long indexDataLength = input.readVLong();
            int dimension = input.readInt();
            int size = input.readInt();
            int[] ordToDoc = new int[size];
            for (int i = 0; i < size; ++i) {
                int doc;
                ordToDoc[i] = doc = input.readVInt();
            }
            long[] ordOffsets = new long[size];
            long offset = 0L;
            for (int i = 0; i < ordOffsets.length; ++i) {
                ordOffsets[i] = offset += input.readVLong();
            }
            return new FieldEntry(similarityFunction, vectorDataOffset, vectorDataLength, indexDataOffset, indexDataLength, dimension, ordToDoc, ordOffsets);
        }

        int size() {
            return this.ordToDoc.length;
        }
    }

    static class OffHeapFloatVectorValues
    extends FloatVectorValues {
        final int dimension;
        final int[] ordToDoc;
        final IndexInput dataIn;
        final int byteSize;
        int lastOrd = -1;
        final float[] value;
        final VectorSimilarityFunction similarityFunction;

        OffHeapFloatVectorValues(int dimension, int[] ordToDoc, VectorSimilarityFunction similarityFunction, IndexInput dataIn) {
            this.dimension = dimension;
            this.ordToDoc = ordToDoc;
            this.dataIn = dataIn;
            this.similarityFunction = similarityFunction;
            this.byteSize = 4 * dimension;
            this.value = new float[dimension];
        }

        public int dimension() {
            return this.dimension;
        }

        public int size() {
            return this.ordToDoc.length;
        }

        public OffHeapFloatVectorValues copy() {
            return new OffHeapFloatVectorValues(this.dimension, this.ordToDoc, this.similarityFunction, this.dataIn.clone());
        }

        public float[] vectorValue(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.value;
            }
            this.dataIn.seek((long)targetOrd * (long)this.byteSize);
            this.dataIn.readFloats(this.value, 0, this.value.length);
            this.lastOrd = targetOrd;
            return this.value;
        }

        public int ordToDoc(int ord) {
            return this.ordToDoc[ord];
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createSparseIterator();
        }

        public VectorScorer scorer(final float[] target) {
            if (this.size() == 0) {
                return null;
            }
            final OffHeapFloatVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                public float score() throws IOException {
                    return values.similarityFunction.compare(values.vectorValue(iterator.index()), target);
                }

                public KnnVectorValues.DocIndexIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final FieldEntry entry;
        final IndexInput dataIn;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.entry = entry;
            this.dataIn = dataIn;
        }

        public void seek(int level, int targetOrd) throws IOException {
            this.dataIn.seek(this.entry.ordOffsets[targetOrd]);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        public int size() {
            return this.entry.size();
        }

        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc += this.dataIn.readVInt();
            return this.arc;
        }

        public int numLevels() {
            throw new UnsupportedOperationException();
        }

        public int entryNode() {
            throw new UnsupportedOperationException();
        }

        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            throw new UnsupportedOperationException();
        }
    }
}

