/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class HtmlDocument {
    private Element rawDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlDocument(File file) throws IOException {
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        Document root = null;
        FileInputStream is = new FileInputStream(file);
        try {
            root = tidy.parseDOM((InputStream)is, null);
        }
        finally {
            ((InputStream)is).close();
        }
        this.rawDoc = root.getDocumentElement();
    }

    public HtmlDocument(InputStream is) {
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        Document root = tidy.parseDOM(is, null);
        this.rawDoc = root.getDocumentElement();
    }

    public HtmlDocument(File file, String tidyConfigFile) throws IOException {
        Tidy tidy = new Tidy();
        tidy.setConfigurationFromFile(tidyConfigFile);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        Document root = tidy.parseDOM((InputStream)new FileInputStream(file), null);
        this.rawDoc = root.getDocumentElement();
    }

    public static org.apache.lucene.document.Document Document(File file, String tidyConfigFile) throws IOException {
        HtmlDocument htmlDoc = new HtmlDocument(file, tidyConfigFile);
        org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
        luceneDoc.add((Fieldable)new Field("title", htmlDoc.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
        luceneDoc.add((Fieldable)new Field("contents", htmlDoc.getBody(), Field.Store.YES, Field.Index.ANALYZED));
        String contents = null;
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringWriter sw = new StringWriter();
        String line = br.readLine();
        while (line != null) {
            sw.write(line);
            line = br.readLine();
        }
        br.close();
        contents = sw.toString();
        sw.close();
        luceneDoc.add((Fieldable)new Field("rawcontents", contents, Field.Store.YES, Field.Index.NO));
        return luceneDoc;
    }

    public static org.apache.lucene.document.Document getDocument(InputStream is) {
        HtmlDocument htmlDoc = new HtmlDocument(is);
        org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
        luceneDoc.add((Fieldable)new Field("title", htmlDoc.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
        luceneDoc.add((Fieldable)new Field("contents", htmlDoc.getBody(), Field.Store.YES, Field.Index.ANALYZED));
        return luceneDoc;
    }

    public static org.apache.lucene.document.Document Document(File file) throws IOException {
        HtmlDocument htmlDoc = new HtmlDocument(file);
        org.apache.lucene.document.Document luceneDoc = new org.apache.lucene.document.Document();
        luceneDoc.add((Fieldable)new Field("title", htmlDoc.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
        luceneDoc.add((Fieldable)new Field("contents", htmlDoc.getBody(), Field.Store.YES, Field.Index.ANALYZED));
        String contents = null;
        BufferedReader br = new BufferedReader(new FileReader(file));
        StringWriter sw = new StringWriter();
        String line = br.readLine();
        while (line != null) {
            sw.write(line);
            line = br.readLine();
        }
        br.close();
        contents = sw.toString();
        sw.close();
        luceneDoc.add((Fieldable)new Field("rawcontents", contents, Field.Store.YES, Field.Index.NO));
        return luceneDoc;
    }

    public static void main(String[] args) throws Exception {
        HtmlDocument doc = new HtmlDocument(new FileInputStream(new File(args[0])));
        System.out.println("Title = " + doc.getTitle());
        System.out.println("Body  = " + doc.getBody());
    }

    public String getTitle() {
        Element titleElement;
        Text text;
        if (this.rawDoc == null) {
            return null;
        }
        String title = "";
        NodeList nl = this.rawDoc.getElementsByTagName("title");
        if (nl.getLength() > 0 && (text = (Text)(titleElement = (Element)nl.item(0)).getFirstChild()) != null) {
            title = text.getData();
        }
        return title;
    }

    public String getBody() {
        if (this.rawDoc == null) {
            return null;
        }
        String body = "";
        NodeList nl = this.rawDoc.getElementsByTagName("body");
        if (nl.getLength() > 0) {
            body = this.getBodyText(nl.item(0));
        }
        return body;
    }

    private String getBodyText(Node node) {
        NodeList nl = node.getChildNodes();
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    buffer.append(this.getBodyText(child));
                    buffer.append(" ");
                    continue block4;
                }
                case 3: {
                    buffer.append(((Text)child).getData());
                }
            }
        }
        return buffer.toString();
    }
}

