/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima.ae;

import java.util.Map;
import org.apache.lucene.analysis.uima.ae.BasicAEProvider;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;

public class OverridingParamsAEProvider
extends BasicAEProvider {
    private final Map<String, Object> runtimeParameters;

    public OverridingParamsAEProvider(String aePath, Map<String, Object> runtimeParameters) {
        super(aePath);
        this.runtimeParameters = runtimeParameters;
    }

    @Override
    protected void configureDescription(AnalysisEngineDescription description) {
        for (String attributeName : this.runtimeParameters.keySet()) {
            Object val = this.getRuntimeValue(description, attributeName);
            description.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue(attributeName, val);
        }
    }

    private Object getRuntimeValue(AnalysisEngineDescription desc, String attributeName) {
        String type = desc.getAnalysisEngineMetaData().getConfigurationParameterDeclarations().getConfigurationParameter(null, attributeName).getType();
        Object val = null;
        Object runtimeValue = this.runtimeParameters.get(attributeName);
        if (runtimeValue != null) {
            if ("String".equals(type)) {
                val = String.valueOf(runtimeValue);
            } else if ("Integer".equals(type)) {
                val = Integer.valueOf(runtimeValue.toString());
            } else if ("Boolean".equals(type)) {
                val = Boolean.valueOf(runtimeValue.toString());
            } else if ("Float".equals(type)) {
                val = Float.valueOf(runtimeValue.toString());
            }
        }
        return val;
    }
}

