/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.UIMATypeAwareAnnotationsTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class UIMATypeAwareAnnotationsTokenizerFactory
extends TokenizerFactory {
    private String descriptorPath;
    private String tokenType;
    private String featurePath;
    private Map<String, Object> configurationParameters;

    public void init(Map<String, String> args) {
        super.init(args);
        this.configurationParameters = new HashMap<String, Object>();
        for (String k : args.keySet()) {
            if (k.equals("featurePath")) {
                this.featurePath = args.get("featurePath");
                continue;
            }
            if (k.equals("tokenType")) {
                this.tokenType = args.get("tokenType");
                continue;
            }
            if (k.equals("descriptorPath")) {
                this.descriptorPath = args.get("descriptorPath");
                continue;
            }
            this.configurationParameters.put(k, args.get(k));
        }
        if (this.descriptorPath == null || this.tokenType == null || this.featurePath == null) {
            throw new IllegalArgumentException("descriptorPath, tokenType, and featurePath are mandatory");
        }
    }

    public Tokenizer create(Reader input) {
        return new UIMATypeAwareAnnotationsTokenizer(this.descriptorPath, this.tokenType, this.featurePath, this.configurationParameters, input);
    }
}

