/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web.appender;

import javax.servlet.ServletContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Servlet")
public final class ServletAppender
extends AbstractAppender {
    private final ServletContext servletContext;
    private final boolean logThrowables;

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private ServletAppender(String name, Layout layout, Filter filter, ServletContext servletContext, boolean ignoreExceptions, boolean logThrowables, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.servletContext = servletContext;
        this.logThrowables = logThrowables;
    }

    public void append(LogEvent event) {
        String serialized = ((AbstractStringLayout)this.getLayout()).toSerializable(event);
        if (this.logThrowables) {
            this.servletContext.log(serialized, event.getThrown());
        } else {
            this.servletContext.log(serialized);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<ServletAppender> {
        @PluginBuilderAttribute
        private boolean logThrowables;

        public ServletAppender build() {
            ServletContext servletContext;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for ServletAppender");
            }
            if ((servletContext = WebLoggerContextUtils.getServletContext()) == null) {
                LOGGER.error("No servlet context is available");
                return null;
            }
            Layout layout = this.getLayout();
            if (layout == null) {
                layout = PatternLayout.createDefaultLayout();
            } else if (!(layout instanceof AbstractStringLayout)) {
                LOGGER.error("Layout must be a StringLayout to log to ServletContext");
                return null;
            }
            return new ServletAppender(name, layout, this.getFilter(), servletContext, this.isIgnoreExceptions(), this.logThrowables, this.getPropertyArray());
        }

        public boolean isLogThrowables() {
            return this.logThrowables;
        }

        public void setLogThrowables(boolean logThrowables) {
            this.logThrowables = logThrowables;
        }
    }
}

