/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.boot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.spring.boot.SpringEnvironmentHolder;
import org.apache.logging.log4j.status.StatusLogger;
import org.springframework.core.env.Environment;

@Plugin(name="spring", category="Lookup")
public class SpringLookup
extends SpringEnvironmentHolder
implements StrLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String ACTIVE = "profiles.active";
    private static final String DEFAULT = "profiles.default";
    private static final String PATTERN = "\\[(\\d+?)\\]";
    private static final Pattern ACTIVE_PATTERN = Pattern.compile("profiles.active\\[(\\d+?)\\]");
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("profiles.default\\[(\\d+?)\\]");

    public SpringLookup() {
        this.getEnvironment();
    }

    public String lookup(String key) {
        Environment env = this.getEnvironment();
        if (env != null) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith(ACTIVE)) {
                switch (env.getActiveProfiles().length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return env.getActiveProfiles()[0];
                    }
                }
                Matcher matcher = ACTIVE_PATTERN.matcher(key);
                if (matcher.matches()) {
                    try {
                        int index = Integer.parseInt(matcher.group(1));
                        if (index < env.getActiveProfiles().length) {
                            return env.getActiveProfiles()[index];
                        }
                        LOGGER.warn("Index out of bounds for Spring active profiles: {}", (Object)index);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unable to parse {} as integer value", (Object)matcher.group(1));
                        return null;
                    }
                }
                return String.join((CharSequence)",", env.getActiveProfiles());
            }
            if (lowerKey.startsWith(DEFAULT)) {
                switch (env.getDefaultProfiles().length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return env.getDefaultProfiles()[0];
                    }
                }
                Matcher matcher = DEFAULT_PATTERN.matcher(key);
                if (matcher.matches()) {
                    try {
                        int index = Integer.parseInt(matcher.group(1));
                        if (index < env.getDefaultProfiles().length) {
                            return env.getDefaultProfiles()[index];
                        }
                        LOGGER.warn("Index out of bounds for Spring default profiles: {}", (Object)index);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unable to parse {} as integer value", (Object)matcher.group(1));
                        return null;
                    }
                }
                return String.join((CharSequence)",", env.getDefaultProfiles());
            }
            return env.getProperty(key);
        }
        return null;
    }

    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }
}

