/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.resolver.AbstractPluginFactoryResolver;
import org.apache.logging.log4j.plugins.di.resolver.Plugins;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.plugins.model.PluginType;

public class PluginStreamPluginTypeFactoryResolver<T>
extends AbstractPluginFactoryResolver<Stream<? extends PluginType<? extends T>>> {
    @Override
    protected boolean supportsType(Type rawType, Type ... typeArguments) {
        if (rawType != Stream.class) {
            return false;
        }
        Type streamTypeArgument = typeArguments[0];
        if (!(streamTypeArgument instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType streamParameterizedTypeArgument = (ParameterizedType)streamTypeArgument;
        if (streamParameterizedTypeArgument.getRawType() != PluginType.class) {
            return false;
        }
        Type[] streamPluginTypeArguments = streamParameterizedTypeArgument.getActualTypeArguments();
        return streamPluginTypeArguments.length == 1;
    }

    @Override
    public Supplier<Stream<? extends PluginType<? extends T>>> getFactory(ResolvableKey<Stream<? extends PluginType<? extends T>>> resolvableKey, InstanceFactory instanceFactory) {
        String namespace = resolvableKey.getNamespace();
        ParameterizedType streamType = (ParameterizedType)resolvableKey.getType();
        ParameterizedType supplierType = (ParameterizedType)streamType.getActualTypeArguments()[0];
        ParameterizedType pluginType = (ParameterizedType)supplierType.getActualTypeArguments()[0];
        Type componentType = pluginType.getActualTypeArguments()[0];
        return () -> Plugins.streamPluginTypesMatching(instanceFactory, namespace, componentType);
    }
}

