/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.visit;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginNodeVisitor
implements NodeVisitor {
    private static final Logger LOGGER = StatusLogger.getLogger();

    @Override
    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable(field.getGenericType(), node.getClass())) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"node", (Object)node.getName(), (CharSequence)", ");
            return Cast.cast((Object)node);
        }
        LOGGER.error("Cannot inject Node instance into field {}", (Object)field);
        return null;
    }

    @Override
    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        if (TypeUtil.isAssignable(parameter.getParameterizedType(), node.getClass())) {
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)"node", (Object)node.getName(), (CharSequence)", ");
            return Cast.cast((Object)node);
        }
        LOGGER.error("Cannot inject Node instance into parameter {}", (Object)parameter);
        return null;
    }
}

