/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.logging.log4j.plugins.di.InjectException;

@FunctionalInterface
public interface ReflectionAccessor {
    public void makeAccessible(AccessibleObject var1);

    default public <M extends AccessibleObject> void makeAccessible(M member, Object instance) {
        boolean isStatic = Modifier.isStatic(((Member)((Object)member)).getModifiers());
        if (!member.canAccess(isStatic ? null : instance)) {
            this.makeAccessible(member);
        }
    }

    default public Object getFieldValue(Field field, Object instance) {
        this.makeAccessible(field, instance);
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw ReflectionAccessor.errorFrom(e);
        }
    }

    default public void setFieldValue(Field field, Object instance, Object value) {
        this.makeAccessible(field, instance);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw ReflectionAccessor.errorFrom(e);
        }
    }

    default public Object invokeMethod(Method method, Object instance, Object ... args) {
        this.makeAccessible(method, instance);
        try {
            return method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            throw new InjectException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw ReflectionAccessor.errorFrom(e);
        }
    }

    default public <T> T newInstance(Constructor<T> constructor, Object[] args) {
        this.makeAccessible(constructor, null);
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new InjectException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw ReflectionAccessor.errorFrom(e);
        }
        catch (InstantiationException e) {
            throw new InjectException(e.getMessage(), e);
        }
    }

    private static IllegalAccessError errorFrom(IllegalAccessException e) {
        IllegalAccessError error = new IllegalAccessError(e.getMessage());
        error.initCause(e);
        return error;
    }
}

