/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginValue;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.FactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.plugins.di.spi.StringValueResolver;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class PluginValueFactoryResolver
implements FactoryResolver<String> {
    private final Class<? extends Annotation> annotationType;

    public PluginValueFactoryResolver() {
        this(PluginValue.class);
    }

    protected PluginValueFactoryResolver(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean supportsKey(Key<?> key) {
        return key.getQualifierType() == this.annotationType;
    }

    @Override
    public Supplier<String> getFactory(ResolvableKey<String> resolvableKey, InstanceFactory instanceFactory) {
        return () -> {
            String rawValue;
            Node node = instanceFactory.getInstance(Node.CURRENT_NODE);
            String name = resolvableKey.key().getName();
            String nodeValue = node.getValue();
            Optional<String> attributeValue = node.removeMatchingAttribute(name, resolvableKey.aliases()).filter(Strings::isNotEmpty);
            if (Strings.isNotEmpty((CharSequence)nodeValue)) {
                attributeValue.ifPresent(attribute -> StatusLogger.getLogger().error("Configuration contains {} with both attribute value ({}) AND element value ({}). Please specify only one value. Using the element value.", (Object)node.getName(), attribute, (Object)nodeValue));
                rawValue = nodeValue;
            } else {
                rawValue = attributeValue.orElse(null);
            }
            if (Strings.isEmpty((CharSequence)rawValue) || !instanceFactory.hasBinding(StringValueResolver.KEY)) {
                return rawValue;
            }
            StringValueResolver resolver = instanceFactory.getInstance(StringValueResolver.class);
            return resolver.resolve(rawValue);
        };
    }
}

