/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.spi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.logging.log4j.lang.NonNull;
import org.apache.logging.log4j.lang.NullUnmarked;
import org.apache.logging.log4j.plugins.di.spi.ReflectionException;

@FunctionalInterface
@NullUnmarked
public interface ReflectionAgent {
    public void makeAccessible(@NonNull AccessibleObject var1);

    private <M extends AccessibleObject> void makeAccessible(M member, Object instance) {
        Objects.requireNonNull(member, "member cannot be null");
        boolean isStatic = Modifier.isStatic(((Member)((Object)member)).getModifiers());
        if (!member.canAccess(isStatic ? null : instance)) {
            try {
                this.makeAccessible(member);
            }
            catch (SecurityException | InaccessibleObjectException e) {
                throw new ReflectionException("Unable to make member accessible", e);
            }
        }
    }

    default public Object getFieldValue(@NonNull Field field, Object instance) {
        this.makeAccessible(field, instance);
        try {
            return field.get(instance);
        }
        catch (ExceptionInInitializerError | IllegalAccessException e) {
            throw new ReflectionException("Unable to get field value from " + field, e);
        }
    }

    default public void setFieldValue(@NonNull Field field, Object instance, Object value) {
        this.makeAccessible(field, instance);
        try {
            field.set(instance, value);
        }
        catch (ExceptionInInitializerError | IllegalAccessException e) {
            throw new ReflectionException("Unable to set field value on " + field, e);
        }
    }

    default public Object invokeMethod(@NonNull Method method, Object instance, Object ... args) {
        this.makeAccessible(method, instance);
        try {
            return method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e.getMessage(), e.getCause());
        }
        catch (ExceptionInInitializerError | IllegalAccessException e) {
            throw new ReflectionException("Unable to invoke method " + method, e);
        }
    }

    default public <T> @NonNull T newInstance(@NonNull Constructor<T> constructor, Object ... args) {
        this.makeAccessible(constructor, null);
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e.getMessage(), e.getCause());
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
            throw new ReflectionException("Unable to invoke constructor " + constructor, e);
        }
    }

    default public <T> @NonNull T newInstance(@NonNull Class<T> clazz) {
        return this.newInstance(this.getDefaultConstructor(clazz), new Object[0]);
    }

    private <T> @NonNull Constructor<T> getDefaultConstructor(@NonNull Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                ex.addSuppressed(e);
                throw new ReflectionException("Unable to find default constructor for " + clazz, ex);
            }
        }
    }
}

