/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di.resolver;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.Cast;

class Plugins {
    Plugins() {
    }

    static <T> Key<T> pluginKey(PluginType<T> pluginType) {
        return Key.builder(pluginType.getPluginClass()).setNamespace(pluginType.getNamespace()).setName(pluginType.getName()).get();
    }

    static <T> Stream<? extends PluginType<? extends T>> streamPluginTypesMatching(InstanceFactory instanceFactory, String namespace, Type type) {
        return instanceFactory.getInstance(Key.forClass(PluginNamespace.class).withNamespace(namespace)).stream().filter(pluginType -> TypeUtil.isAssignable(type, pluginType.getPluginClass())).sorted(Comparator.comparing(PluginType::getPluginClass, OrderedComparator.INSTANCE)).map(Cast::cast);
    }

    static <T> Stream<? extends Supplier<? extends T>> streamPluginFactoriesMatching(InstanceFactory instanceFactory, String namespace, Type type) {
        return Plugins.streamPluginTypesMatching(instanceFactory, namespace, type).map(pluginType -> instanceFactory.getFactory(Plugins.pluginKey(pluginType)));
    }

    static <T> Stream<? extends T> streamPluginInstancesMatching(InstanceFactory instanceFactory, String namespace, Type type) {
        return Plugins.streamPluginTypesMatching(instanceFactory, namespace, type).map(pluginType -> instanceFactory.getInstance(Plugins.pluginKey(pluginType)));
    }
}

