/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.processor;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.plugins.processor.PluginEntry;
import org.apache.logging.log4j.plugins.util.PluginNamespace;
import org.apache.logging.log4j.plugins.util.PluginType;

public abstract class PluginService {
    private final Map<String, PluginNamespace> namespaces = new LinkedHashMap<String, PluginNamespace>();

    public PluginService() {
        PluginEntry[] entries = this.getEntries();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (PluginEntry entry : entries) {
            String namespace = entry.getNamespace();
            this.namespaces.computeIfAbsent(namespace.toLowerCase(Locale.ROOT), key -> new PluginNamespace((String)key, namespace)).merge(entry.getKey(), new PluginType(entry, classLoader));
        }
    }

    public abstract PluginEntry[] getEntries();

    public Map<String, PluginNamespace> getNamespaces() {
        return this.namespaces;
    }

    public PluginNamespace getNamespace(String category) {
        return this.namespaces.get(category.toLowerCase(Locale.ROOT));
    }

    public int size() {
        return this.namespaces.values().stream().mapToInt(PluginNamespace::size).sum();
    }
}

