/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.util.TypeUtil;

class BindingMap {
    private final Map<Key<?>, Binding<?>> bindings;

    BindingMap() {
        this.bindings = new ConcurrentHashMap();
    }

    BindingMap(BindingMap bindings) {
        this.bindings = new ConcurrentHashMap(bindings.bindings);
    }

    public <T> Binding<T> get(Key<T> key) {
        return (Binding)TypeUtil.cast(this.bindings.get(key));
    }

    public <T> Binding<T> get(Key<T> key, Collection<String> aliases) {
        Binding<?> binding;
        block1: {
            String alias;
            binding = this.bindings.get(key);
            if (binding != null) break block1;
            Iterator<String> iterator = aliases.iterator();
            while (iterator.hasNext() && (binding = this.bindings.get(key.withName(alias = iterator.next()))) == null) {
            }
        }
        return (Binding)TypeUtil.cast(binding);
    }

    public <T> void put(Key<T> key, Supplier<T> factory) {
        this.bindings.put(key, Binding.bind(key, factory));
    }

    public <T> Supplier<T> merge(Key<T> key, Supplier<T> factory) {
        Binding newBinding = this.bindings.merge(key, Binding.bind(key, factory), (oldBinding, binding) -> oldBinding.getKey().getOrder() <= binding.getKey().getOrder() ? oldBinding : binding);
        return (Supplier)TypeUtil.cast(newBinding.getSupplier());
    }

    public <T> void bindIfAbsent(Key<T> key, Supplier<T> factory) {
        this.bindings.putIfAbsent(key, Binding.bind(key, factory));
    }

    public void remove(Key<?> key) {
        this.bindings.remove(key);
    }
}

