/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.visit;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.name.AnnotatedElementAliasesProvider;
import org.apache.logging.log4j.plugins.name.AnnotatedElementNameProvider;
import org.apache.logging.log4j.plugins.util.PluginType;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilders;

public class PluginElementVisitor
implements NodeVisitor {
    private static final Logger LOGGER = StatusLogger.getLogger();

    @Override
    public Object visitField(Field field, Node node, StringBuilder debugLog) {
        String name = AnnotatedElementNameProvider.getName(field);
        Collection<String> aliases = AnnotatedElementAliasesProvider.getAliases(field);
        Type targetType = field.getGenericType();
        Class<?> componentType = PluginElementVisitor.getComponentType(targetType);
        return TypeUtil.cast(componentType != null ? PluginElementVisitor.parseArrayElement(node, name, aliases, componentType, debugLog) : PluginElementVisitor.parseChildElement(node, name, aliases, targetType, debugLog));
    }

    @Override
    public Object visitParameter(Parameter parameter, Node node, StringBuilder debugLog) {
        String name = AnnotatedElementNameProvider.getName(parameter);
        Collection<String> aliases = AnnotatedElementAliasesProvider.getAliases(parameter);
        Type targetType = parameter.getParameterizedType();
        Class<?> componentType = PluginElementVisitor.getComponentType(targetType);
        return TypeUtil.cast(componentType != null ? PluginElementVisitor.parseArrayElement(node, name, aliases, componentType, debugLog) : PluginElementVisitor.parseChildElement(node, name, aliases, targetType, debugLog));
    }

    private static Object[] parseArrayElement(Node node, String name, Collection<String> aliases, Class<?> componentType, StringBuilder debugLog) {
        Iterator<Node> iterator = node.getChildren().iterator();
        ArrayList values = new ArrayList();
        if (debugLog.length() > 0) {
            debugLog.append(", ");
        }
        debugLog.append(name).append("={");
        boolean first = true;
        while (iterator.hasNext()) {
            Node child = iterator.next();
            PluginType<?> pluginType = child.getType();
            String elementName = pluginType.getElementName();
            if (!name.equalsIgnoreCase(elementName)) {
                if (!aliases.stream().anyMatch(elementName::equalsIgnoreCase) && !componentType.isAssignableFrom(pluginType.getPluginClass())) continue;
            }
            if (!first) {
                debugLog.append(", ");
            }
            first = false;
            Object childObject = child.getObject();
            if (childObject == null) {
                LOGGER.error("Skipping null child object with name {} in element {}", (Object)child.getName(), (Object)node.getName());
                continue;
            }
            iterator.remove();
            if (childObject.getClass().isArray()) {
                Object[] array = (Object[])childObject;
                debugLog.append(Arrays.toString(array)).append('}');
                return array;
            }
            debugLog.append(childObject);
            values.add(childObject);
        }
        debugLog.append('}');
        Object[] objects = (Object[])Array.newInstance(componentType, values.size());
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = values.get(i);
        }
        return objects;
    }

    private static Object parseChildElement(Node node, String name, Collection<String> aliases, Type targetType, StringBuilder debugLog) {
        Iterator<Node> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            Node child = iterator.next();
            PluginType<?> pluginType = child.getType();
            String elementName = pluginType.getElementName();
            if (!name.equalsIgnoreCase(elementName)) {
                if (!aliases.stream().anyMatch(elementName::equalsIgnoreCase) && !TypeUtil.isAssignable(targetType, pluginType.getPluginClass())) continue;
            }
            iterator.remove();
            Object value = child.getObject();
            StringBuilders.appendKeyDqValueWithJoiner((StringBuilder)debugLog, (String)name, value, (CharSequence)", ");
            return value;
        }
        return null;
    }

    private static Class<?> getComponentType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        return null;
    }
}

