/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.processor.PluginEntry;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.LazyValue;

public class PluginType<T> {
    private final PluginEntry pluginEntry;
    private final Supplier<Class<T>> pluginClass;
    private final String elementName;

    public PluginType(PluginEntry pluginEntry, Class<T> pluginClass, String elementName) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = () -> pluginClass;
        this.elementName = elementName;
    }

    public PluginType(PluginEntry pluginEntry, ClassLoader classLoader) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = new LazyValue(() -> {
            try {
                return (Class)TypeUtil.cast(classLoader.loadClass(pluginEntry.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class named " + pluginEntry.getClassName() + " located for element " + pluginEntry.getName(), e);
            }
        });
        this.elementName = pluginEntry.getName();
    }

    public PluginEntry getPluginEntry() {
        return this.pluginEntry;
    }

    public Class<T> getPluginClass() {
        return this.pluginClass.get();
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getKey() {
        return this.pluginEntry.getKey();
    }

    public boolean isObjectPrintable() {
        return this.pluginEntry.isPrintable();
    }

    public boolean isDeferChildren() {
        return this.pluginEntry.isDefer();
    }

    public String getCategory() {
        return this.pluginEntry.getCategory();
    }

    public String toString() {
        return "PluginType [pluginClass=" + this.pluginClass.get() + ", key=" + this.pluginEntry.getKey() + ", elementName=" + this.pluginEntry.getName() + ", isObjectPrintable=" + this.pluginEntry.isPrintable() + ", isDeferChildren==" + this.pluginEntry.isDefer() + ", category=" + this.pluginEntry.getCategory() + "]";
    }
}

