/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.plugins.processor.PluginEntry;
import org.apache.logging.log4j.plugins.util.PluginType;

public abstract class PluginService {
    private final Map<String, List<PluginType<?>>> categories = new LinkedHashMap();

    public PluginService() {
        PluginEntry[] entries = this.getEntries();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (PluginEntry entry : entries) {
            String category = entry.getCategory().toLowerCase();
            List list = this.categories.computeIfAbsent(category, ignored -> new ArrayList());
            PluginType type = new PluginType(entry, classLoader);
            list.add(type);
        }
    }

    public abstract PluginEntry[] getEntries();

    public Map<String, List<PluginType<?>>> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    public List<PluginType<?>> getCategory(String category) {
        return Collections.unmodifiableList(this.categories.get(category.toLowerCase()));
    }

    public long size() {
        return this.categories.size();
    }
}

