/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.osgi;

import java.security.Permission;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.processor.PluginService;
import org.apache.logging.log4j.plugins.util.PluginRegistry;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

public final class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();

    public void start(BundleContext bundleContext) throws Exception {
        Bundle[] bundles;
        this.loadPlugins(bundleContext);
        bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            this.loadPlugins(bundle);
        }
        Activator.scanInstalledBundlesForPlugins(bundleContext);
        this.contextRef.compareAndSet(null, bundleContext);
    }

    private void loadPlugins(BundleContext bundleContext) {
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(PluginService.class, null);
            for (ServiceReference serviceReference : serviceReferences) {
                PluginService pluginService = (PluginService)bundleContext.getService(serviceReference);
                PluginRegistry.getInstance().loadFromBundle(pluginService.getCategories(), bundleContext.getBundle().getBundleId());
            }
        }
        catch (InvalidSyntaxException ex) {
            LOGGER.error("Error accessing Plugins", (Throwable)ex);
        }
    }

    private void loadPlugins(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                LOGGER.debug("Bundle {} has no context (state={}), skipping loading plugins", (Object)bundle.getSymbolicName(), (Object)this.toStateString(bundle.getState()));
            } else {
                this.loadPlugins(bundleContext);
            }
        }
        catch (SecurityException e) {
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", (Object)bundle.getSymbolicName(), (Object)e);
        }
        catch (Exception e) {
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", (Object)bundle.getSymbolicName(), (Object)e);
        }
    }

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkPermission(permission);
        }
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toString(state);
    }

    private static void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            Activator.scanBundleForPlugins(bundle);
        }
    }

    private static void scanBundleForPlugins(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        if (bundle.getState() == 32 && bundleId != 0L) {
            LOGGER.trace("Scanning bundle [{}, id=%d] for plugins.", (Object)bundle.getSymbolicName(), (Object)bundleId);
            PluginRegistry.getInstance().loadFromBundle(bundleId, ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
        }
    }

    private static void stopBundlePlugins(Bundle bundle) {
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle.getSymbolicName());
        PluginRegistry.getInstance().clearBundlePlugins(bundle.getBundleId());
    }

    public void stop(BundleContext context) throws Exception {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            Activator.stopBundlePlugins(bundle);
        }
        Activator.stopBundlePlugins(context.getBundle());
        this.contextRef.compareAndSet(context, null);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.loadPlugins(event.getBundle());
                Activator.scanBundleForPlugins(event.getBundle());
                break;
            }
            case 256: {
                Activator.stopBundlePlugins(event.getBundle());
                break;
            }
        }
    }
}

