/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.name;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.apache.logging.log4j.plugins.internal.util.BeanUtils;
import org.apache.logging.log4j.plugins.name.NameProvider;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.ReflectionUtil;

public interface AnnotatedElementNameProvider<A extends Annotation> {
    public static boolean hasName(AnnotatedElement element) {
        return AnnotationUtil.isMetaAnnotationPresent(element, NameProvider.class);
    }

    public static String getName(Field field) {
        return AnnotatedElementNameProvider.hasName(field) ? AnnotatedElementNameProvider.getSpecifiedName(field).orElseGet(field::getName) : "";
    }

    public static String getName(Parameter parameter) {
        return AnnotatedElementNameProvider.hasName(parameter) ? AnnotatedElementNameProvider.getSpecifiedName(parameter).orElseGet(parameter::getName) : "";
    }

    public static String getName(Method method) {
        return AnnotatedElementNameProvider.hasName(method) ? AnnotatedElementNameProvider.getSpecifiedName(method).orElseGet(() -> {
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                return BeanUtils.decapitalize(methodName.substring(2));
            }
            if (methodName.startsWith("set") || methodName.startsWith("get")) {
                return BeanUtils.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith("with")) {
                return BeanUtils.decapitalize(methodName.substring(4));
            }
            return methodName;
        }) : "";
    }

    public static String getName(AnnotatedType annotatedType) {
        return AnnotatedElementNameProvider.hasName(annotatedType) ? AnnotatedElementNameProvider.getSpecifiedName(annotatedType).orElse("") : "";
    }

    public static String getName(Class<?> type) {
        return AnnotatedElementNameProvider.hasName(type) ? AnnotatedElementNameProvider.getSpecifiedName(type).orElseGet(type::getName) : "";
    }

    private static Optional<String> getSpecifiedName(AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            Optional<String> name = AnnotatedElementNameProvider.getSpecifiedNameForAnnotation(annotation);
            if (!name.isPresent()) continue;
            return name;
        }
        return Optional.empty();
    }

    private static <A extends Annotation> Optional<String> getSpecifiedNameForAnnotation(A annotation) {
        return Optional.ofNullable(annotation.annotationType().getAnnotation(NameProvider.class)).map(NameProvider::value).map(TypeUtil::cast).map(ReflectionUtil::instantiate).flatMap(provider -> provider.getSpecifiedName(annotation));
    }

    public Optional<String> getSpecifiedName(A var1);
}

