/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.name.AnnotatedElementNameProvider;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.TypeUtil;

public class Key<T> {
    private final Type type;
    private final Class<T> rawType;
    private final Class<? extends Annotation> qualifierType;
    private final String name;
    private final int hashCode;
    private String toString;

    protected Key() {
        this.type = TypeUtil.getSuperclassTypeParameter(this.getClass());
        this.rawType = (Class)TypeUtil.cast(TypeUtil.getRawType(this.type));
        AnnotatedType superclass = this.getClass().getAnnotatedSuperclass();
        Annotation qualifier = AnnotationUtil.getMetaAnnotation(superclass, QualifierType.class);
        this.qualifierType = qualifier != null ? qualifier.annotationType() : null;
        this.name = AnnotatedElementNameProvider.getName(superclass);
        this.hashCode = Objects.hash(this.type, this.qualifierType, this.name.toLowerCase(Locale.ROOT));
    }

    private Key(Type type, Class<T> rawType, Class<? extends Annotation> qualifierType, String name) {
        this.type = type;
        this.rawType = rawType;
        this.qualifierType = qualifierType;
        this.name = name;
        this.hashCode = Objects.hash(type, qualifierType, name.toLowerCase(Locale.ROOT));
    }

    public Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getQualifierType() {
        return this.qualifierType;
    }

    public final Key<T> withName(String name) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, name);
    }

    public final Key<T> withQualifierType(Class<? extends Annotation> qualifierType) {
        return new Key<T>(this.type, this.rawType, qualifierType, this.name);
    }

    public final <P> Key<P> getSuppliedType() {
        if (this.type instanceof ParameterizedType && Supplier.class.isAssignableFrom(this.rawType)) {
            return Key.forQualifiedNamedType(this.qualifierType, this.name, ((ParameterizedType)this.type).getActualTypeArguments()[0]);
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return TypeUtil.isEqual(this.type, that.type) && this.name.equalsIgnoreCase(that.name) && Objects.equals(this.qualifierType, that.qualifierType);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        Object string = this.toString;
        if (string == null) {
            this.toString = string = "Key{type=" + this.type.getTypeName() + ", qualifierType=" + this.qualifierType + ", name='" + this.name + "'}";
        }
        return string;
    }

    public static <T> Key<T> forClass(Class<T> clazz) {
        return Key.forQualifiedNamedType(Key.getQualifierType(clazz), AnnotatedElementNameProvider.getName(clazz), clazz);
    }

    public static <T> Key<T> forMethod(Method method) {
        return Key.forQualifiedNamedType(Key.getQualifierType(method), AnnotatedElementNameProvider.getName(method), method.getGenericReturnType());
    }

    public static <T> Key<T> forParameter(Parameter parameter) {
        return Key.forQualifiedNamedType(Key.getQualifierType(parameter), AnnotatedElementNameProvider.getName(parameter), parameter.getParameterizedType());
    }

    public static <T> Key<T> forField(Field field) {
        return Key.forQualifiedNamedType(Key.getQualifierType(field), AnnotatedElementNameProvider.getName(field), field.getGenericType());
    }

    private static <T> Key<T> forQualifiedNamedType(Class<? extends Annotation> qualifierType, String name, Type type) {
        Class rawType = (Class)TypeUtil.cast(TypeUtil.getRawType(type));
        return new Key<T>(type, rawType, qualifierType, name);
    }

    private static Class<? extends Annotation> getQualifierType(AnnotatedElement element) {
        Annotation qualifierAnnotation = AnnotationUtil.getMetaAnnotation(element, QualifierType.class);
        return qualifierAnnotation != null ? qualifierAnnotation.annotationType() : null;
    }
}

