/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.bind;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.bind.ConfigurationBinder;
import org.apache.logging.log4j.plugins.bind.ConfigurationBindingException;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.plugins.name.AnnotatedElementNameProvider;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.validation.ConstraintValidators;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractConfigurationBinder<E extends AnnotatedElement>
implements ConfigurationBinder {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    final E element;
    final String name;
    private final Type injectionType;
    private final Collection<ConstraintValidator<?>> validators;

    AbstractConfigurationBinder(E element, Function<E, Type> injectionTypeExtractor) {
        this.element = (AnnotatedElement)Objects.requireNonNull(element);
        this.name = AnnotatedElementNameProvider.getName(element);
        Objects.requireNonNull(injectionTypeExtractor);
        this.injectionType = Objects.requireNonNull(injectionTypeExtractor.apply(element));
        this.validators = ConstraintValidators.findValidators(element.getAnnotations());
    }

    @Override
    public void bindString(Object factory, String value) {
        Object convertedValue = null;
        if (value != null) {
            TypeConverter<?> converter = TypeConverterRegistry.getInstance().findCompatibleConverter(this.injectionType);
            try {
                convertedValue = converter.convert(value);
            }
            catch (Exception e) {
                throw new ConfigurationBindingException(this.name, value, e);
            }
        }
        this.bindObject(factory, convertedValue);
    }

    void validate(Object value) {
        boolean valid = true;
        for (ConstraintValidator<?> validator : this.validators) {
            valid &= validator.isValid(this.name, value);
        }
        if (!valid) {
            throw new ConfigurationBindingException(this.name, value);
        }
    }
}

