/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.processor.PluginEntry;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.plugins.*", "org.apache.logging.log4j.core.config.plugins.*"})
public class PluginProcessor
extends AbstractProcessor {
    public static final String PLUGIN_CACHE_FILE = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private static final String SERVICE_FILE_NAME = "META-INF/services/org.apache.logging.log4j.plugins.processor.PluginService";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, String> options = this.processingEnv.getOptions();
        String packageName = options.get("pluginPackage");
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Processing Log4j annotations");
        try {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Plugin.class);
            if (elements.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "No elements to process");
                return false;
            }
            ArrayList<PluginEntry> list = new ArrayList<PluginEntry>();
            packageName = this.collectPlugins(packageName, elements, list);
            this.writeClassFile(packageName, list);
            this.writeServiceFile(packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Annotations processed");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.error(ex.getMessage());
            return false;
        }
    }

    private void error(CharSequence message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private String collectPlugins(String packageName, Iterable<? extends Element> elements, List<PluginEntry> list) {
        boolean calculatePackage = packageName == null;
        Elements elementUtils = this.processingEnv.getElementUtils();
        PluginElementVisitor pluginVisitor = new PluginElementVisitor(elementUtils);
        PluginAliasesElementVisitor pluginAliasesVisitor = new PluginAliasesElementVisitor(elementUtils);
        for (Element element : elements) {
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntry entry = element.accept(pluginVisitor, plugin);
            list.add(entry);
            if (calculatePackage) {
                packageName = this.calculatePackage(elementUtils, element, packageName);
            }
            Collection<PluginEntry> entries = element.accept(pluginAliasesVisitor, plugin);
            for (PluginEntry pluginEntry : entries) {
                list.add(pluginEntry);
            }
        }
        return packageName;
    }

    private String calculatePackage(Elements elements, Element element, String packageName) {
        Name name = elements.getPackageOf(element).getQualifiedName();
        if (name == null) {
            return null;
        }
        String pkgName = name.toString();
        if (packageName == null) {
            return pkgName;
        }
        if (pkgName.length() == packageName.length()) {
            return packageName;
        }
        if (pkgName.length() < packageName.length() && packageName.startsWith(pkgName)) {
            return pkgName;
        }
        return this.commonPrefix(pkgName, packageName);
    }

    private void writeServiceFile(String pkgName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_FILE_NAME, new Element[0]);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileObject.openOutputStream(), StandardCharsets.UTF_8)));){
            writer.println(this.createFqcn(pkgName));
        }
    }

    private void writeClassFile(String pkg, List<PluginEntry> list) {
        String fqcn = this.createFqcn(pkg);
        try (PrintWriter writer = this.createSourceFile(fqcn);){
            writer.println("package " + pkg + ".plugins;");
            writer.println("");
            writer.println("import org.apache.logging.log4j.plugins.processor.PluginEntry;");
            writer.println("import org.apache.logging.log4j.plugins.processor.PluginService;");
            writer.println("");
            writer.println("public class Log4jPlugins extends PluginService {");
            writer.println("");
            writer.println("    private static PluginEntry[] entries = new PluginEntry[] {");
            StringBuilder sb = new StringBuilder();
            int max = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                PluginEntry entry = list.get(i);
                sb.append("        ").append("new PluginEntry(\"");
                sb.append(entry.getKey()).append("\", \"");
                sb.append(entry.getClassName()).append("\", \"");
                sb.append(entry.getName()).append("\", ");
                sb.append(entry.isPrintable()).append(", ");
                sb.append(entry.isDefer()).append(", \"");
                sb.append(entry.getCategory()).append("\")");
                if (i < max) {
                    sb.append(",");
                }
                writer.println(sb.toString());
                sb.setLength(0);
            }
            writer.println("    };");
            writer.println("    @Override");
            writer.println("    public PluginEntry[] getEntries() { return entries;}");
            writer.println("}");
        }
    }

    private PrintWriter createSourceFile(String fqcn) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(fqcn, new Element[0]);
            return new PrintWriter(sourceFile.openWriter());
        }
        catch (IOException e) {
            throw new LoggingException("Unable to create Plugin Service Class " + fqcn, (Throwable)e);
        }
    }

    private String createFqcn(String packageName) {
        return packageName + ".plugins.Log4jPlugins";
    }

    private String commonPrefix(String str1, String str2) {
        int minLength = str1.length() < str2.length() ? str1.length() : str2.length();
        for (int i = 0; i < minLength; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            if (i > 1 && str1.charAt(i - 1) == '.') {
                return str1.substring(0, i - 1);
            }
            return str1.substring(0, i);
        }
        return str1.substring(0, minLength);
    }

    private static class PluginAliasesElementVisitor
    extends SimpleElementVisitor7<Collection<PluginEntry>, Plugin> {
        private final Elements elements;

        private PluginAliasesElementVisitor(Elements elements) {
            super(Collections.emptyList());
            this.elements = elements;
        }

        @Override
        public Collection<PluginEntry> visitType(TypeElement e, Plugin plugin) {
            PluginAliases aliases = e.getAnnotation(PluginAliases.class);
            if (aliases == null) {
                return (Collection)this.DEFAULT_VALUE;
            }
            ArrayList<PluginEntry> entries = new ArrayList<PluginEntry>(aliases.value().length);
            for (String alias : aliases.value()) {
                PluginEntry entry = new PluginEntry();
                entry.setKey(alias.toLowerCase(Locale.US));
                entry.setClassName(this.elements.getBinaryName(e).toString());
                entry.setName("".equals(plugin.elementType()) ? alias : plugin.elementType());
                entry.setPrintable(plugin.printObject());
                entry.setDefer(plugin.deferChildren());
                entry.setCategory(plugin.category());
                entries.add(entry);
            }
            return entries;
        }
    }

    private static class PluginElementVisitor
    extends SimpleElementVisitor7<PluginEntry, Plugin> {
        private final Elements elements;

        private PluginElementVisitor(Elements elements) {
            this.elements = elements;
        }

        @Override
        public PluginEntry visitType(TypeElement e, Plugin plugin) {
            Objects.requireNonNull(plugin, "Plugin annotation is null.");
            PluginEntry entry = new PluginEntry();
            entry.setKey(plugin.name().toLowerCase(Locale.US));
            entry.setClassName(this.elements.getBinaryName(e).toString());
            entry.setName("".equals(plugin.elementType()) ? plugin.name() : plugin.elementType());
            entry.setPrintable(plugin.printObject());
            entry.setDefer(plugin.deferChildren());
            entry.setCategory(plugin.category());
            return entry;
        }
    }
}

