/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.inject;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.inject.AbstractConfigurationInjector;
import org.apache.logging.log4j.util.NameUtil;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class PluginAttributeInjector
extends AbstractConfigurationInjector<PluginAttribute, Object> {
    private static final Map<Type, Function<PluginAttribute, Object>> DEFAULT_VALUE_EXTRACTORS;

    @Override
    public void inject(Object factory) {
        Optional value = this.findAndRemoveNodeAttribute().map(this.stringSubstitutionStrategy);
        if (value.isPresent()) {
            this.configurationBinder.bindString(factory, (String)value.get());
        } else {
            this.injectDefaultValue(factory);
        }
    }

    private void injectDefaultValue(Object factory) {
        Function<PluginAttribute, Object> extractor = DEFAULT_VALUE_EXTRACTORS.get(this.conversionType);
        if (extractor != null) {
            Object value = extractor.apply((PluginAttribute)this.annotation);
            this.debugLog(value);
            this.configurationBinder.bindObject(factory, value);
        } else {
            String value = (String)this.stringSubstitutionStrategy.apply(((PluginAttribute)this.annotation).defaultString());
            if (Strings.isNotBlank((String)value)) {
                this.debugLog(value);
                this.configurationBinder.bindString(factory, value);
            }
        }
    }

    private void debugLog(Object value) {
        Object debugValue = ((PluginAttribute)this.annotation).sensitive() ? NameUtil.md5((String)(value + this.getClass().getName())) : value;
        StringBuilders.appendKeyDqValue((StringBuilder)this.debugLog, (String)this.name, (Object)debugValue);
    }

    static {
        ConcurrentHashMap<Class, Function<PluginAttribute, Object>> extractors = new ConcurrentHashMap<Class, Function<PluginAttribute, Object>>();
        extractors.put(Integer.TYPE, PluginAttribute::defaultInt);
        extractors.put(Integer.class, PluginAttribute::defaultInt);
        extractors.put(Long.TYPE, PluginAttribute::defaultLong);
        extractors.put(Long.class, PluginAttribute::defaultLong);
        extractors.put(Boolean.TYPE, PluginAttribute::defaultBoolean);
        extractors.put(Boolean.class, PluginAttribute::defaultBoolean);
        extractors.put(Float.TYPE, PluginAttribute::defaultFloat);
        extractors.put(Float.class, PluginAttribute::defaultFloat);
        extractors.put(Double.TYPE, PluginAttribute::defaultDouble);
        extractors.put(Double.class, PluginAttribute::defaultDouble);
        extractors.put(Byte.TYPE, PluginAttribute::defaultByte);
        extractors.put(Byte.class, PluginAttribute::defaultByte);
        extractors.put(Character.TYPE, PluginAttribute::defaultChar);
        extractors.put(Character.class, PluginAttribute::defaultChar);
        extractors.put(Short.TYPE, PluginAttribute::defaultShort);
        extractors.put(Short.class, PluginAttribute::defaultShort);
        extractors.put(Class.class, PluginAttribute::defaultClass);
        DEFAULT_VALUE_EXTRACTORS = Collections.unmodifiableMap(extractors);
    }
}

