/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.processor;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.plugins.processor.PluginEntry;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String category) {
        String key = category.toLowerCase();
        return this.categories.computeIfAbsent(key, ignored -> new TreeMap());
    }

    public void loadCacheFiles(Enumeration<URL> resources) throws IOException {
        this.categories.clear();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            DataInputStream in = new DataInputStream(new BufferedInputStream(url.openStream()));
            Throwable throwable = null;
            try {
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    String category = in.readUTF();
                    Map<String, PluginEntry> m = this.getCategory(category);
                    int entries = in.readInt();
                    for (int j = 0; j < entries; ++j) {
                        String key = in.readUTF();
                        String className = in.readUTF();
                        String name = in.readUTF();
                        boolean printable = in.readBoolean();
                        boolean defer = in.readBoolean();
                        m.computeIfAbsent(key, k -> new PluginEntry((String)k, className, name, printable, defer, category));
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

